/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.model;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentIdentifierTest;
import org.mule.munit.plugins.coverage.core.model.CoverageTypedComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import utils.ComponentLocationUtils;

public class CoverageTypedComponentIdentifierTest {
    @Test
    public void validateEquals() {
        TypedComponentIdentifier typedComponentIdentifier = ComponentLocationUtils.buildComponentIdentifier("mule", "flow", TypedComponentIdentifier.ComponentType.FLOW);
        CoverageTypedComponentIdentifier typedComponentIdentifierOne = CoverageTypedComponentIdentifier.fromTypedComponentIdentifier((TypedComponentIdentifier)typedComponentIdentifier);
        CoverageTypedComponentIdentifier typedComponentIdentifierTwo = CoverageTypedComponentIdentifier.fromTypedComponentIdentifier((TypedComponentIdentifier)typedComponentIdentifier);
        MatcherAssert.assertThat((Object)typedComponentIdentifierOne.equals((Object)typedComponentIdentifierTwo), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)typedComponentIdentifierTwo.equals((Object)typedComponentIdentifierOne), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateFromTypedComponentIdentifier() {
        TypedComponentIdentifier typedComponentIdentifier = ComponentLocationUtils.buildComponentIdentifier("mule", "flow", TypedComponentIdentifier.ComponentType.FLOW);
        CoverageTypedComponentIdentifier coverageTypedComponentIdentifier = CoverageTypedComponentIdentifier.fromTypedComponentIdentifier((TypedComponentIdentifier)typedComponentIdentifier);
        CoverageTypedComponentIdentifierTest.assertCoverageTypedComponentIdentifier((TypedComponentIdentifier)coverageTypedComponentIdentifier, typedComponentIdentifier);
    }

    public static void assertCoverageTypedComponentIdentifier(TypedComponentIdentifier coverageTypedComponentIdentifier, TypedComponentIdentifier typedComponentIdentifier) {
        MatcherAssert.assertThat((Object)coverageTypedComponentIdentifier.getType(), (Matcher)Is.is((Object)typedComponentIdentifier.getType()));
        CoverageComponentIdentifierTest.assertComponentIdentifier(coverageTypedComponentIdentifier.getIdentifier(), typedComponentIdentifier.getIdentifier());
    }
}

