/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReportBuilder;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import utils.CoverageComponentLocationUtils;

public class ApplicationCoverageReportBuilderTest {
    private Set<String> suitePaths;
    private static final double DELTA = 1.0E-5;

    @Before
    public void setUp() {
        this.suitePaths = new HashSet<String>(Arrays.asList("a-test-suite.xml"));
    }

    @Test(expected=NullPointerException.class)
    public void constructNullAllLocations() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        new ApplicationCoverageReportBuilder(null, coveredLocations, this.suitePaths);
    }

    @Test(expected=NullPointerException.class)
    public void constructNullCoveredLocations() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        new ApplicationCoverageReportBuilder(locations, null, this.suitePaths);
    }

    @Test(expected=NullPointerException.class)
    public void constructNullSuitePaths() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        new ApplicationCoverageReportBuilder(locations, coveredLocations, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructEmptySuitePaths() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        new ApplicationCoverageReportBuilder(locations, coveredLocations, Collections.emptySet());
    }

    @Test
    public void getSuitePaths() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        MatcherAssert.assertThat((Object)builder.getSuitePaths(), (Matcher)Is.is(this.suitePaths));
    }

    @Test(expected=NullPointerException.class)
    public void setFlowsToIgnoreNullSet() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFlowsToIgnore(null);
    }

    @Test
    public void setFlowsToIgnore() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        HashSet flowsToIgnore = Sets.newHashSet((Object[])new String[]{"tomFlow", "aFlow"});
        builder.setFlowsToIgnore((Set)flowsToIgnore);
        MatcherAssert.assertThat((Object)builder.getFlowsToIgnore(), (Matcher)Is.is((Object)flowsToIgnore));
    }

    @Test(expected=NullPointerException.class)
    public void setFilesToIgnoreNullSet() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFilesToIgnore(null);
    }

    @Test
    public void setFilesToIgnore() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        HashSet filesToIgnore = Sets.newHashSet((Object[])new String[]{"file-one.xml", "file-two.xml"});
        builder.setFilesToIgnore((Set)filesToIgnore);
        MatcherAssert.assertThat((Object)builder.getFilesToIgnore(), (Matcher)Is.is((Object)filesToIgnore));
    }

    @Test
    public void validateFullApplication() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        ApplicationCoverageReport report = builder.build();
        Double expectedCoverage = this.getExpectedCoverage(locations, coveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Double expectedWeightFileOne = (double)CoverageComponentLocationUtils.getFileOneLocationSet().size() * 100.0 / (double)CoverageComponentLocationUtils.getAllLocationSet().size();
        Double expectedWeightFileTwo = (double)CoverageComponentLocationUtils.getFileTwoLocationSet().size() * 100.0 / (double)CoverageComponentLocationUtils.getAllLocationSet().size();
        MatcherAssert.assertThat((String)"Resource count is not as expected", (Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        this.assertMuleResource(report, "file-one.xml", 3, 100.0, expectedWeightFileOne);
        this.assertMuleResource(report, "file-two.xml", 2, 100.0, expectedWeightFileTwo);
    }

    @Test
    public void suitePathsAllButFileTwo() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getAllLocationSet();
        this.suitePaths = Sets.newHashSet((Object[])new String[]{"file-one.xml", "file-three.xml"});
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount() - this.suitePaths.size();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        ApplicationCoverageReport report = builder.build();
        MatcherAssert.assertThat((String)"Resource count is not as expected", (Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        Double expectedCoverage = this.getExpectedCoverage(CoverageComponentLocationUtils.getFileTwoLocationSet(), CoverageComponentLocationUtils.getFileTwoLocationSet());
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Double expectedWeightFileTwo = this.getExpectedCoverage(CoverageComponentLocationUtils.getFileTwoLocationSet(), CoverageComponentLocationUtils.getFileTwoLocationSet());
        this.assertMuleResource(report, "file-two.xml", 2, 100.0, expectedWeightFileTwo);
    }

    @Test
    public void suitePathsAllButFileOne() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getAllLocationSet();
        this.suitePaths = Sets.newHashSet((Object[])new String[]{"file-two.xml", "file-three.xml"});
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount() - this.suitePaths.size();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        ApplicationCoverageReport report = builder.build();
        MatcherAssert.assertThat((String)"Resource count is not as expected", (Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        Double expectedCoverage = this.getExpectedCoverage(CoverageComponentLocationUtils.getFileOneLocationSet(), CoverageComponentLocationUtils.getFileOneLocationSet());
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Double expectedWeightFileOne = this.getExpectedCoverage(CoverageComponentLocationUtils.getFileOneLocationSet(), CoverageComponentLocationUtils.getFileOneLocationSet());
        this.assertMuleResource(report, "file-one.xml", 3, 100.0, expectedWeightFileOne);
    }

    @Test
    public void validateAFlow() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getAFLowLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 3;
        String resourceName = "file-one.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileOneLocationSet();
        String flowName = "aFlow";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getAFLowLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void validateASubFlow() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getASubFlowLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 3;
        String resourceName = "file-one.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileOneLocationSet();
        String flowName = "aSubFlow";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getASubFlowLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void validateAFlowWithForEach() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getAFlowWithForEachLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 3;
        String resourceName = "file-one.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileOneLocationSet();
        String flowName = "aFlowWithForEach";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getAFlowWithForEachLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void validateTomFlow() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getTomFLowLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 2;
        String resourceName = "file-two.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileTwoLocationSet();
        String flowName = "tomFlow";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getTomFLowLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void validatePaulSubFlow() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getPaulSubFlowLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 2;
        String resourceName = "file-two.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileTwoLocationSet();
        String flowName = "paulSubFlow";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getPaulSubFlowLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void validateAFlowWithErrorHandling() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getAFlowWithErrorHandlingLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 2;
        String resourceName = "file-three.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileThreeLocationSet();
        String flowName = "aFlowWithErrorHandling";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getAFlowWithErrorHandlingLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void validateAFlowChoice() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getAllLocationSet();
        Set<CoverageComponentLocation> coveredLocations = CoverageComponentLocationUtils.getAFlowWithChoiceLocationSet(false);
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        Integer resourceFlowCount = 2;
        String resourceName = "file-three.xml";
        Set<CoverageComponentLocation> resourceLocationSet = CoverageComponentLocationUtils.getFileThreeLocationSet();
        String flowName = "aFlowWithChoice";
        Set<CoverageComponentLocation> flowLocationSet = CoverageComponentLocationUtils.getAFlowWithChoiceLocationSet();
        this.assertFlowCoverage(locations, coveredLocations, resourceCount, resourceFlowCount, resourceName, resourceLocationSet, flowName, flowLocationSet);
    }

    @Test
    public void ignoreTwoFlows() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFlowsToIgnore((Set)Sets.newHashSet((Object[])new String[]{"tomFlow", "aFlow"}));
        ApplicationCoverageReport report = builder.build();
        HashSet<CoverageComponentLocation> ignoredLocations = new HashSet<CoverageComponentLocation>();
        ignoredLocations.addAll(CoverageComponentLocationUtils.getTomFLowLocationSet());
        ignoredLocations.addAll(CoverageComponentLocationUtils.getAFLowLocationSet());
        HashSet effectiveAllLocations = Sets.newHashSet(locations);
        effectiveAllLocations.removeAll(ignoredLocations);
        HashSet effectiveCoveredLocations = Sets.newHashSet(coveredLocations);
        effectiveCoveredLocations.removeAll(ignoredLocations);
        Double expectedCoverage = this.getExpectedCoverage(effectiveAllLocations, effectiveCoveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Set<CoverageComponentLocation> effectiveFileOneLocations = CoverageComponentLocationUtils.getFileOneLocationSet();
        effectiveFileOneLocations.removeAll(CoverageComponentLocationUtils.getAFLowLocationSet());
        Set<CoverageComponentLocation> effectiveFileTwoLocations = CoverageComponentLocationUtils.getFileTwoLocationSet();
        effectiveFileTwoLocations.removeAll(CoverageComponentLocationUtils.getTomFLowLocationSet());
        Double expectedWeightFileOne = (double)effectiveFileOneLocations.size() * 100.0 / (double)effectiveAllLocations.size();
        Double expectedWeightFileTwo = (double)effectiveFileTwoLocations.size() * 100.0 / (double)effectiveAllLocations.size();
        MatcherAssert.assertThat((Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        this.assertMuleResource(report, "file-one.xml", 2, 100.0, expectedWeightFileOne);
        this.assertMuleResource(report, "file-two.xml", 1, 100.0, expectedWeightFileTwo);
    }

    @Test
    public void ignoreAllFlowsFromFileTwo() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFlowsToIgnore(CoverageComponentLocationUtils.getFileTwoFlowNames());
        ApplicationCoverageReport report = builder.build();
        HashSet<CoverageComponentLocation> ignoredLocations = new HashSet<CoverageComponentLocation>();
        ignoredLocations.addAll(CoverageComponentLocationUtils.getTomFLowLocationSet());
        ignoredLocations.addAll(CoverageComponentLocationUtils.getPaulSubFlowLocationSet());
        HashSet effectiveAllLocations = Sets.newHashSet(locations);
        effectiveAllLocations.removeAll(ignoredLocations);
        HashSet effectiveCoveredLocations = Sets.newHashSet(coveredLocations);
        effectiveCoveredLocations.removeAll(ignoredLocations);
        Double expectedCoverage = this.getExpectedCoverage(effectiveAllLocations, effectiveCoveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Set<CoverageComponentLocation> effectiveFileTwoLocations = CoverageComponentLocationUtils.getFileTwoLocationSet();
        effectiveFileTwoLocations.removeAll(CoverageComponentLocationUtils.getTomFLowLocationSet());
        effectiveFileTwoLocations.removeAll(CoverageComponentLocationUtils.getPaulSubFlowLocationSet());
        Double expectedWeightFileOne = (double)CoverageComponentLocationUtils.getFileOneLocationSet().size() * 100.0 / (double)effectiveAllLocations.size();
        Double expectedWeightFileTwo = (double)effectiveFileTwoLocations.size() * 100.0 / (double)effectiveAllLocations.size();
        MatcherAssert.assertThat((String)"The resource count is not as expected", (Object)report.getResources().size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getFileCount()));
        this.assertMuleResource(report, "file-one.xml", 3, 100.0, expectedWeightFileOne);
        this.assertMuleResource(report, "file-two.xml", 0, -1.0, expectedWeightFileTwo);
    }

    @Test
    public void ignoreAllFlows() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFlowsToIgnore(CoverageComponentLocationUtils.getAllFilesFlowNames());
        ApplicationCoverageReport report = builder.build();
        Set<CoverageComponentLocation> effectiveAllLocations = Collections.emptySet();
        Set<CoverageComponentLocation> effectiveCoveredLocations = Collections.emptySet();
        Double expectedCoverage = this.getExpectedCoverage(effectiveAllLocations, effectiveCoveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        MatcherAssert.assertThat((String)"The resource count is not as expected", (Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        Double expectedWeightFileOne = 0.0;
        Double expectedWeightFileTwo = 0.0;
        this.assertMuleResource(report, "file-one.xml", 0, -1.0, expectedWeightFileOne);
        this.assertMuleResource(report, "file-two.xml", 0, -1.0, expectedWeightFileTwo);
    }

    @Test
    public void ignoringNonExistentFlows() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFlowsToIgnore((Set)Sets.newHashSet((Object[])new String[]{"NON_EXISTENT_FLOW", "OTHER_NON_EXISTENT_FLOW"}));
        ApplicationCoverageReport report = builder.build();
        Double expectedCoverage = this.getExpectedCoverage(locations, coveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Double expectedWeightFileOne = (double)CoverageComponentLocationUtils.getFileOneLocationSet().size() * 100.0 / (double)CoverageComponentLocationUtils.getAllLocationSet().size();
        Double expectedWeightFileTwo = (double)CoverageComponentLocationUtils.getFileTwoLocationSet().size() * 100.0 / (double)CoverageComponentLocationUtils.getAllLocationSet().size();
        MatcherAssert.assertThat((Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        this.assertMuleResource(report, "file-one.xml", 3, 100.0, expectedWeightFileOne);
        this.assertMuleResource(report, "file-two.xml", 2, 100.0, expectedWeightFileTwo);
    }

    @Test
    public void ignoreFileTwo() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        Integer resourceCount = CoverageComponentLocationUtils.getFileCount() - 1;
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFilesToIgnore((Set)Sets.newHashSet((Object[])new String[]{"file-two.xml"}));
        ApplicationCoverageReport report = builder.build();
        Set<CoverageComponentLocation> ignoredLocations = CoverageComponentLocationUtils.getFileTwoLocationSet();
        HashSet effectiveAllLocations = Sets.newHashSet(locations);
        effectiveAllLocations.removeAll(ignoredLocations);
        HashSet effectiveCoveredLocations = Sets.newHashSet(coveredLocations);
        effectiveCoveredLocations.removeAll(ignoredLocations);
        Double expectedCoverage = this.getExpectedCoverage(effectiveAllLocations, effectiveCoveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Double expectedWeightFileOne = (double)CoverageComponentLocationUtils.getFileOneLocationSet().size() * 100.0 / (double)effectiveAllLocations.size();
        MatcherAssert.assertThat((Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        this.assertMuleResource(report, "file-one.xml", 3, 100.0, expectedWeightFileOne);
    }

    @Test
    public void ignoreFlowAndFile() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        Integer resourceCount = 2;
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFlowsToIgnore((Set)Sets.newHashSet((Object[])new String[]{"aFlow"}));
        builder.setFilesToIgnore((Set)Sets.newHashSet((Object[])new String[]{"file-two.xml"}));
        ApplicationCoverageReport report = builder.build();
        HashSet<CoverageComponentLocation> ignoredLocations = new HashSet<CoverageComponentLocation>();
        ignoredLocations.addAll(CoverageComponentLocationUtils.getFileTwoLocationSet());
        ignoredLocations.addAll(CoverageComponentLocationUtils.getAFLowLocationSet());
        HashSet effectiveAllLocations = Sets.newHashSet(locations);
        effectiveAllLocations.removeAll(ignoredLocations);
        HashSet effectiveCoveredLocations = Sets.newHashSet(coveredLocations);
        effectiveCoveredLocations.removeAll(ignoredLocations);
        Double expectedCoverage = this.getExpectedCoverage(effectiveAllLocations, effectiveCoveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        Set<CoverageComponentLocation> effectiveFileOneLocations = CoverageComponentLocationUtils.getFileOneLocationSet();
        effectiveFileOneLocations.removeAll(CoverageComponentLocationUtils.getAFLowLocationSet());
        Double expectedWeightFileOne = (double)effectiveFileOneLocations.size() * 100.0 / (double)effectiveAllLocations.size();
        MatcherAssert.assertThat((Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        this.assertMuleResource(report, "file-one.xml", 2, 100.0, expectedWeightFileOne);
    }

    @Test
    public void ignoreAllFiles() {
        Set<CoverageComponentLocation> locations;
        Set<CoverageComponentLocation> coveredLocations = locations = CoverageComponentLocationUtils.getAllLocationSet();
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        builder.setFilesToIgnore((Set)Sets.newHashSet((Object[])new String[]{"file-one.xml", "file-two.xml", "file-three.xml"}));
        ApplicationCoverageReport report = builder.build();
        Set<CoverageComponentLocation> effectiveAllLocations = Collections.emptySet();
        Set<CoverageComponentLocation> effectiveCoveredLocations = Collections.emptySet();
        Double expectedCoverage = this.getExpectedCoverage(effectiveAllLocations, effectiveCoveredLocations);
        Assert.assertEquals((double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        MatcherAssert.assertThat((Object)report.getResources().isEmpty(), (Matcher)Is.is((Object)true));
    }

    private void assertFlowCoverage(Set<CoverageComponentLocation> locations, Set<CoverageComponentLocation> coveredLocations, Integer resourceCount, Integer resourceFlowCount, String resourceName, Set<CoverageComponentLocation> resourceLocationSet, String flowName, Set<CoverageComponentLocation> flowLocationSet) {
        ApplicationCoverageReportBuilder builder = new ApplicationCoverageReportBuilder(locations, coveredLocations, this.suitePaths);
        ApplicationCoverageReport report = builder.build();
        Double expectedCoverage = this.getExpectedCoverage(locations, coveredLocations);
        Assert.assertEquals((String)"The report coverage is not as expected", (double)expectedCoverage, (double)report.getCoverage(), (double)1.0E-5);
        MatcherAssert.assertThat((String)"The number of resources is nos as expected", (Object)report.getResources().size(), (Matcher)Is.is((Object)resourceCount));
        Double expectedResourceCoverage = this.getExpectedCoverage(resourceLocationSet, coveredLocations);
        Double expectedFileWeight = (double)resourceLocationSet.size() * 100.0 / (double)CoverageComponentLocationUtils.getAllLocationSet().size();
        this.assertMuleResource(report, resourceName, resourceFlowCount, expectedResourceCoverage, expectedFileWeight);
        MuleResource resource = this.lookupMuleResource(report, resourceName);
        this.assertMuleFlow(resource, flowName, this.getExpectedCoverage(flowLocationSet, coveredLocations));
    }

    private void assertMuleResource(ApplicationCoverageReport report, String resourceName, Integer expectedFlowCount, Double expectedCoverage, Double expectedWeight) {
        MuleResource resource = this.lookupMuleResource(report, resourceName);
        MatcherAssert.assertThat((String)"Resource name is not as expected", (Object)resource.getName(), (Matcher)Is.is((Object)resourceName));
        MatcherAssert.assertThat((String)"Resource's flow count is not as expected", (Object)resource.getFlows().size(), (Matcher)Is.is((Object)expectedFlowCount));
        Assert.assertEquals((String)"Resource Coverage is not as expected", (double)expectedCoverage, (double)resource.getCoverage(), (double)1.0E-5);
        Assert.assertEquals((String)"Resource Weight is not as expected", (double)expectedWeight, (double)resource.getWeight(), (double)1.0E-5);
    }

    private MuleResource lookupMuleResource(ApplicationCoverageReport report, String resourceName) {
        return report.getResources().stream().filter(r -> resourceName.equals(r.getName())).findFirst().get();
    }

    private void assertMuleFlow(MuleResource resource, String flowName, Double expectedFlowCoverage) {
        MuleFlow flow = resource.getFlows().stream().filter(f -> flowName.equals(f.getName())).findFirst().get();
        MatcherAssert.assertThat((String)"Flow name is not as expected", (Object)flow.getName(), (Matcher)Is.is((Object)flowName));
        Assert.assertEquals((String)"Flow coverage is not as expected", (double)expectedFlowCoverage, (double)flow.getCoverage(), (double)1.0E-5);
    }

    private Double getExpectedCoverage(Set<CoverageComponentLocation> locations, Set<CoverageComponentLocation> coveredLocations) {
        return locations.isEmpty() ? -1.0 : (double)coveredLocations.size() * 100.0 / (double)locations.size();
    }
}

