/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.server.CoverageLocations;

public class CoverageLocationsTest {
    @Test(expected=NullPointerException.class)
    public void constructionNullLocations() {
        new CoverageLocations(null);
    }

    @Test
    public void validateIsAllLocations() {
        HashSet<CoverageComponentLocation> componentLocations = new HashSet<CoverageComponentLocation>();
        CoverageComponentLocation location = CoverageComponentLocation.fromSingleComponent((String)"mule:logger");
        componentLocations.add(location);
        CoverageLocations report = new CoverageLocations(componentLocations);
        MatcherAssert.assertThat((Object)report.isAllLocations(), (Matcher)Is.is((Object)Boolean.FALSE));
        report.setAllLocations(Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)report.isAllLocations(), (Matcher)Is.is((Object)Boolean.TRUE));
    }

    @Test
    public void validateGetCoveredLocations() {
        HashSet<CoverageComponentLocation> componentLocations = new HashSet<CoverageComponentLocation>();
        CoverageComponentLocation location = CoverageComponentLocation.fromSingleComponent((String)"mule:logger");
        componentLocations.add(location);
        CoverageLocations report = new CoverageLocations(componentLocations);
        MatcherAssert.assertThat((Object)report.getCoverageLocations(), (Matcher)Is.is(componentLocations));
    }
}

