/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.core.model.CoverageLocationPart;
import org.mule.munit.plugins.coverage.report.LocationGrouper;
import org.mule.runtime.api.component.location.LocationPart;
import utils.CoverageComponentLocationUtils;

public class LocationGrouperTest {
    @Test(expected=NullPointerException.class)
    public void validateNullCoveredLocations() {
        new LocationGrouper(null);
    }

    @Test
    public void groupByFlowEmptyCoveredLocations() {
        LocationGrouper locationGrouper = new LocationGrouper(Collections.emptySet());
        Map locationsPerFlow = locationGrouper.groupByFlow();
        MatcherAssert.assertThat((Object)locationsPerFlow.keySet().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void groupByFlowWithSeveralLocations() {
        Set<CoverageComponentLocation> locations = CoverageComponentLocationUtils.getFileOneLocationSet();
        LocationGrouper locationGrouper = new LocationGrouper(locations);
        Map locationsPerFlow = locationGrouper.groupByFlow();
        MatcherAssert.assertThat((Object)locationsPerFlow.keySet().size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)((Set)locationsPerFlow.get(CoverageComponentLocationUtils.flowPart("aFlow", "file-one.xml", 0))).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getAFLowLocationSet().size()));
        MatcherAssert.assertThat((Object)((Set)locationsPerFlow.get(CoverageComponentLocationUtils.flowPart("aSubFlow", "file-one.xml", 15))).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getASubFlowLocationSet().size()));
        MatcherAssert.assertThat((Object)((Set)locationsPerFlow.get(CoverageComponentLocationUtils.flowPart("aFlowWithForEach", "file-one.xml", 16))).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getAFlowWithForEachLocationSet().size()));
    }

    @Test
    public void groupByFlowAFlow() {
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart("aFlow", "file-one.xml", 0);
        Set<CoverageComponentLocation> locationSet = CoverageComponentLocationUtils.getAFLowLocationSet();
        this.validateGroupByFlow((LocationPart)flowPart, locationSet);
    }

    @Test
    public void groupByFlowAFlowWithForEach() {
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart("aFlowWithForEach", "file-one.xml", 16);
        Set<CoverageComponentLocation> locationSet = CoverageComponentLocationUtils.getAFlowWithForEachLocationSet();
        this.validateGroupByFlow((LocationPart)flowPart, locationSet);
    }

    @Test
    public void groupByFileEmptyCoveredLocations() {
        LocationGrouper locationGrouper = new LocationGrouper(Collections.emptySet());
        Map locationsPerFile = locationGrouper.groupByFile();
        MatcherAssert.assertThat((Object)locationsPerFile.keySet().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void groupByFileFileOne() {
        Integer fileCount = 1;
        Set<CoverageComponentLocation> locationSet = CoverageComponentLocationUtils.getFileOneLocationSet();
        Map locationsPerFile = new LocationGrouper(locationSet).groupByFile();
        MatcherAssert.assertThat((Object)locationsPerFile.keySet().size(), (Matcher)Is.is((Object)fileCount));
        MatcherAssert.assertThat((Object)((Set)locationsPerFile.get("file-one.xml")).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getFileOneLocationSet().size()));
        this.assertLocations(locationSet, (Set)locationsPerFile.get("file-one.xml"));
    }

    @Test
    public void groupByFileAllFiles() {
        Integer fileCount = CoverageComponentLocationUtils.getFileCount();
        Set<CoverageComponentLocation> locationSet = CoverageComponentLocationUtils.getAllLocationSet();
        Map locationsPerFile = new LocationGrouper(locationSet).groupByFile();
        MatcherAssert.assertThat((Object)locationsPerFile.keySet().size(), (Matcher)Is.is((Object)fileCount));
        MatcherAssert.assertThat((Object)((Set)locationsPerFile.get("file-one.xml")).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getFileOneLocationSet().size()));
        this.assertLocations(locationSet, (Set)locationsPerFile.get("file-one.xml"));
        MatcherAssert.assertThat((Object)((Set)locationsPerFile.get("file-two.xml")).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getFileTwoLocationSet().size()));
        this.assertLocations(locationSet, (Set)locationsPerFile.get("file-two.xml"));
        MatcherAssert.assertThat((Object)((Set)locationsPerFile.get("file-three.xml")).size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getFileThreeLocationSet().size()));
        this.assertLocations(locationSet, (Set)locationsPerFile.get("file-three.xml"));
    }

    private void validateGroupByFlow(LocationPart flowPart, Set<CoverageComponentLocation> locationSet) {
        Map locationsPerFlow = new LocationGrouper(locationSet).groupByFlow();
        MatcherAssert.assertThat((Object)locationsPerFlow.keySet().size(), (Matcher)Is.is((Object)1));
        Set locationsInFlow = (Set)locationsPerFlow.get(flowPart);
        MatcherAssert.assertThat((Object)locationsInFlow.size(), (Matcher)Is.is((Object)CoverageComponentLocationUtils.getAFlowWithForEachLocationSet().size()));
        this.assertLocations(locationSet, locationsInFlow);
    }

    private void assertLocations(Set<CoverageComponentLocation> actualLocationSet, Set<CoverageComponentLocation> expectedLocationSet) {
        expectedLocationSet.forEach(lf -> MatcherAssert.assertThat((Object)actualLocationSet.contains(lf), (Matcher)Is.is((Object)true)));
    }
}

