/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class ApplicationCoverageReportTest {
    private List<MuleResource> muleResources;
    private Integer pathCount;
    private Integer coveredPathCount;
    private Integer muleFlowCount;

    @Before
    public void setUp() {
        ArrayList<MuleLocation> paths = new ArrayList<MuleLocation>();
        paths.add(this.asMuleLocation("/aMuleFlow/processors/0", 1));
        paths.add(this.asMuleLocation("/aMuleFlow/processors/1", 2));
        paths.add(this.asMuleLocation("/aMuleFlow/processors/2", 3));
        this.pathCount = paths.size();
        ArrayList<MuleLocation> coveredPaths = new ArrayList<MuleLocation>();
        coveredPaths.add(this.asMuleLocation("/aMuleFlow/processors/0", 1));
        coveredPaths.add(this.asMuleLocation("/aMuleFlow/processors/1", 2));
        this.coveredPathCount = coveredPaths.size();
        MatcherAssert.assertThat((String)"setUp Fail pathCount should be grater or equal than the coveredPathCount", (Object)(this.pathCount >= this.coveredPathCount ? 1 : 0), (Matcher)Is.is((Object)true));
        MuleFlow muleFlow = new MuleFlow("aMuleFlow");
        muleFlow.setLocations(paths);
        muleFlow.setCoveredLocations(coveredPaths);
        ArrayList<MuleFlow> muleFlows = new ArrayList<MuleFlow>();
        muleFlows.add(muleFlow);
        this.muleFlowCount = muleFlows.size();
        MuleResource muleResource = new MuleResource("aMuleFile.xml");
        muleResource.setFlows(muleFlows);
        this.muleResources = new ArrayList<MuleResource>();
        this.muleResources.add(muleResource);
    }

    @Test(expected=NullPointerException.class)
    public void constructionNullResources() {
        new ApplicationCoverageReport(null);
    }

    @Test
    public void getApplicationFlowCountEmptyResources() {
        ApplicationCoverageReport report = new ApplicationCoverageReport();
        MatcherAssert.assertThat((Object)report.getApplicationFlowCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void getApplicationFlowCount() {
        ApplicationCoverageReport report = new ApplicationCoverageReport(this.muleResources);
        MatcherAssert.assertThat((Object)report.getApplicationFlowCount(), (Matcher)Is.is((Object)this.muleFlowCount));
    }

    @Test
    public void getApplicationMessageProcessorCountEmptyResources() {
        ApplicationCoverageReport report = new ApplicationCoverageReport();
        MatcherAssert.assertThat((Object)report.getApplicationMessageProcessorCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void getApplicationMessageProcessorCount() {
        ApplicationCoverageReport report = new ApplicationCoverageReport(this.muleResources);
        MatcherAssert.assertThat((Object)report.getApplicationMessageProcessorCount(), (Matcher)Is.is((Object)this.pathCount));
    }

    @Test
    public void getApplicationCoveredMessageProcessorCountEmptyResources() {
        ApplicationCoverageReport report = new ApplicationCoverageReport();
        MatcherAssert.assertThat((Object)report.getApplicationCoveredMessageProcessorCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void getApplicationCoveredMessageProcessorCount() {
        ApplicationCoverageReport report = new ApplicationCoverageReport(this.muleResources);
        MatcherAssert.assertThat((Object)report.getApplicationCoveredMessageProcessorCount(), (Matcher)Is.is((Object)this.coveredPathCount));
    }

    private MuleLocation asMuleLocation(String path, Integer lineNumber) {
        return new MuleLocation(path, lineNumber);
    }
}

