/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;

public class MuleFlowTest {
    private static final double DELTA = 1.0E-5;
    public static final String FLOW_NAME = "flow";
    private MuleFlow muleFlow;

    @Before
    public void setUp() {
        this.muleFlow = new MuleFlow(FLOW_NAME);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructNullName() {
        new MuleFlow(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructEmptyName() {
        new MuleFlow("");
    }

    @Test
    public void getName() {
        MatcherAssert.assertThat((Object)this.muleFlow.getName(), (Matcher)Is.is((Object)FLOW_NAME));
    }

    @Test(expected=NullPointerException.class)
    public void setPathsNull() {
        this.muleFlow.setLocations(null);
    }

    @Test
    public void getPaths() {
        ArrayList<MuleLocation> paths = new ArrayList<MuleLocation>();
        paths.add(this.asMuleLocation("aPath", 1));
        this.muleFlow.setLocations(paths);
        MatcherAssert.assertThat((Object)this.muleFlow.getLocations(), (Matcher)Is.is(paths));
    }

    @Test(expected=NullPointerException.class)
    public void setCoveredPathsNull() {
        this.muleFlow.setCoveredLocations(null);
    }

    @Test
    public void getCoveredPaths() {
        ArrayList<MuleLocation> paths = new ArrayList<MuleLocation>();
        paths.add(this.asMuleLocation("aPath", 1));
        this.muleFlow.setCoveredLocations(paths);
        MatcherAssert.assertThat((Object)this.muleFlow.getCoveredLocations(), (Matcher)Is.is(paths));
    }

    @Test
    public void fiftyPercentCoverageIfHalfOfPathsAreCovered() {
        this.muleFlow.setLocations(Arrays.asList(this.asMuleLocation("path1", 1), this.asMuleLocation("path2", 2)));
        this.muleFlow.setCoveredLocations(Arrays.asList(this.asMuleLocation("path1", 1)));
        Assert.assertEquals((double)this.muleFlow.getCoverage(), (double)50.0, (double)1.0E-5);
    }

    @Test
    public void minusOneIfNoPaths() {
        this.muleFlow.setLocations(Collections.EMPTY_LIST);
        this.muleFlow.setCoveredLocations(Collections.EMPTY_LIST);
        Assert.assertEquals((double)this.muleFlow.getCoverage(), (double)-1.0, (double)1.0E-5);
    }

    @Test
    public void HundredPercentIfAllPathsCovered() {
        this.muleFlow.setLocations(Arrays.asList(this.asMuleLocation("path1", 1), this.asMuleLocation("path2", 2)));
        this.muleFlow.setCoveredLocations(Arrays.asList(this.asMuleLocation("path1", 1), this.asMuleLocation("path2", 2)));
        Assert.assertEquals((double)this.muleFlow.getCoverage(), (double)100.0, (double)1.0E-5);
    }

    @Test
    public void zeroPercentIfNoPathsCovered() {
        this.muleFlow.setLocations(Arrays.asList(this.asMuleLocation("path1", 1), this.asMuleLocation("path2", 2)));
        this.muleFlow.setCoveredLocations(Collections.EMPTY_LIST);
        Assert.assertEquals((double)this.muleFlow.getCoverage(), (double)0.0, (double)1.0E-5);
    }

    private MuleLocation asMuleLocation(String path, Integer lineNumber) {
        return new MuleLocation(path, lineNumber);
    }
}

