/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;

public class MuleLocationTest {
    @Test(expected=IllegalArgumentException.class)
    public void constructNullPath() {
        new MuleLocation(null, Integer.valueOf(1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructEmptyPath() {
        new MuleLocation("", Integer.valueOf(1));
    }

    @Test(expected=NullPointerException.class)
    public void constructNullLineNumber() {
        new MuleLocation("/a/path/0", null);
    }

    @Test
    public void construct() {
        String path = "/a/path/0";
        int lineNumber = 1;
        MuleLocation muleLocation = new MuleLocation(path, Integer.valueOf(lineNumber));
        MatcherAssert.assertThat((String)"Mule location should not be null", (Object)muleLocation, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((String)"The path is wrong", (Object)muleLocation.getPath(), (Matcher)Is.is((Object)path));
        MatcherAssert.assertThat((String)"The line number is wrong", (Object)muleLocation.getLineNumber(), (Matcher)Is.is((Object)lineNumber));
    }

    @Test
    public void validateEqualsDifferentLine() {
        String path = "/a/path/0";
        int lineNumber = 1;
        MuleLocation aLocation = new MuleLocation(path, Integer.valueOf(lineNumber));
        MuleLocation anotherLocation = new MuleLocation(path, Integer.valueOf(2));
        MatcherAssert.assertThat((String)"Mule locations should NOT be equal", (Object)aLocation.equals((Object)anotherLocation), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"Mule locations should NOT be equal", (Object)anotherLocation.equals((Object)aLocation), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateEqualsDifferentPath() {
        String path = "/a/path/0";
        int lineNumber = 1;
        MuleLocation aLocation = new MuleLocation(path, Integer.valueOf(lineNumber));
        MuleLocation anotherLocation = new MuleLocation("/another/path/0", Integer.valueOf(lineNumber));
        MatcherAssert.assertThat((String)"Mule locations should NOT be equal", (Object)aLocation.equals((Object)anotherLocation), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"Mule locations should NOT be equal", (Object)anotherLocation.equals((Object)aLocation), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateEquals() {
        String path = "/a/path/0";
        int lineNumber = 1;
        MuleLocation aLocation = new MuleLocation(path, Integer.valueOf(lineNumber));
        MuleLocation anotherLocation = new MuleLocation(path, Integer.valueOf(lineNumber));
        MatcherAssert.assertThat((String)"Mule locations should be equal", (Object)aLocation.equals((Object)anotherLocation), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Mule locations should be equal", (Object)anotherLocation.equals((Object)aLocation), (Matcher)Is.is((Object)true));
    }
}

