/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class MuleResourceTest {
    private static final double DELTA = 1.0E-5;
    public static final String RESOURCE_NAME = "resource";
    private MuleResource muleResource;

    @Before
    public void setUp() {
        this.muleResource = new MuleResource(RESOURCE_NAME);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructNullName() {
        new MuleResource(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructEmptyName() {
        new MuleResource("");
    }

    @Test
    public void getName() {
        MatcherAssert.assertThat((Object)this.muleResource.getName(), (Matcher)Is.is((Object)RESOURCE_NAME));
    }

    @Test(expected=NullPointerException.class)
    public void setFlowsNull() {
        this.muleResource.setFlows(null);
    }

    @Test
    public void getFlows() {
        ArrayList<MuleFlow> flows = new ArrayList<MuleFlow>();
        MuleFlow muleFlowMock = (MuleFlow)Mockito.mock(MuleFlow.class);
        flows.add(muleFlowMock);
        this.muleResource.setFlows(flows);
        MatcherAssert.assertThat((Object)this.muleResource.getFlows(), (Matcher)Is.is(flows));
    }

    @Test
    public void fiftyPercentCoverageIfHalfOfPathsAreCovered() {
        this.muleResource.setFlows(this.generateFlows());
        Assert.assertEquals((double)this.muleResource.getCoverage(), (double)50.0, (double)1.0E-5);
    }

    @Test
    public void messageProcessorCountCalculation() {
        this.muleResource.setFlows(this.generateFlows());
        Assert.assertEquals((long)this.muleResource.getMessageProcessorCount().intValue(), (long)2L);
    }

    @Test
    public void minusOneCoverageIfFileHasNoFlows() {
        this.muleResource.setFlows(Collections.EMPTY_LIST);
        Assert.assertEquals((double)this.muleResource.getCoverage(), (double)-1.0, (double)1.0E-5);
    }

    @Test
    public void zeroMessageProcessorCountIfFileHasNoFlows() {
        this.muleResource.setFlows(Collections.EMPTY_LIST);
        Assert.assertEquals((long)this.muleResource.getMessageProcessorCount().intValue(), (long)0L);
    }

    private List<MuleFlow> generateFlows() {
        MuleFlow flow1 = (MuleFlow)Mockito.mock(MuleFlow.class);
        MuleFlow flow2 = (MuleFlow)Mockito.mock(MuleFlow.class);
        Mockito.when((Object)flow1.getCoveredLocations()).thenReturn((Object)Collections.EMPTY_LIST);
        Mockito.when((Object)flow1.getLocations()).thenReturn(Arrays.asList(new MuleLocation("path1", Integer.valueOf(1))));
        Mockito.when((Object)flow2.getCoveredLocations()).thenReturn(Arrays.asList(new MuleLocation("path2", Integer.valueOf(2))));
        Mockito.when((Object)flow2.getLocations()).thenReturn(Arrays.asList(new MuleLocation("path2", Integer.valueOf(2))));
        return Arrays.asList(flow1, flow2);
    }
}

