/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.printer;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.CoverageLimits;
import org.mule.munit.plugins.coverage.report.printer.JsonPrinter;

public class JsonPrinterTest {
    private JsonPrinter printer;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    File reportFile;

    @Before
    public void setUp() {
        this.reportFile = this.temporaryFolder.getRoot().toPath().resolve("jsonReport.json").toFile();
        this.printer = new JsonPrinter((CoverageLimits)Mockito.mock(CoverageLimits.class), this.reportFile);
    }

    @Test(expected=NullPointerException.class)
    public void constructionWithNullReportFile() {
        new JsonPrinter((CoverageLimits)Mockito.mock(CoverageLimits.class), null);
    }

    @Test(expected=NullPointerException.class)
    public void constructionWithNullCoverageLimits() {
        new JsonPrinter(null, this.temporaryFolder.getRoot());
    }

    @Test
    public void printingReport() {
        this.printer.printReport((ApplicationCoverageReport)Mockito.mock(ApplicationCoverageReport.class));
        Assert.assertEquals((Object)true, (Object)this.reportFile.exists());
    }

    @Test
    public void printingReportWithException() {
        this.printer.printReport(null);
        Assert.assertEquals((Object)false, (Object)this.reportFile.exists());
    }

    @Test
    public void getPrinterName() {
        Assert.assertEquals((Object)"Json", (Object)this.printer.getPrinterName());
    }
}

