/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.printer;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.CoverageLimits;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import org.mule.munit.plugins.coverage.report.printer.SonarPrinter;
import org.mule.munit.plugins.coverage.report.printer.model.sonar.SonarCoverage;
import org.mule.munit.plugins.coverage.report.printer.model.sonar.SonarFile;
import org.mule.munit.plugins.coverage.report.printer.model.sonar.SonarLineToCover;

public class SonarPrinterTest {
    private SonarPrinter printer;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    File reportFile;

    @Before
    public void setUp() {
        this.reportFile = this.temporaryFolder.getRoot().toPath().resolve("sonarReport.xml").toFile();
        this.printer = new SonarPrinter((CoverageLimits)Mockito.mock(CoverageLimits.class), this.reportFile);
    }

    @Test(expected=NullPointerException.class)
    public void constructionWithNullReportFile() {
        new SonarPrinter((CoverageLimits)Mockito.mock(CoverageLimits.class), null);
    }

    @Test(expected=NullPointerException.class)
    public void constructionWithNullCoverageLimits() {
        new SonarPrinter(null, this.temporaryFolder.getRoot());
    }

    @Test
    public void printingReport() {
        this.printer.printReport((ApplicationCoverageReport)Mockito.mock(ApplicationCoverageReport.class));
        Assert.assertEquals((Object)true, (Object)this.reportFile.exists());
    }

    @Test
    public void printingReportWithException() {
        this.printer.printReport(null);
        Assert.assertEquals((Object)false, (Object)this.reportFile.exists());
    }

    @Test
    public void getPrinterName() {
        Assert.assertEquals((Object)"SONAR", (Object)this.printer.getPrinterName());
    }

    @Test
    public void validateFileResult() {
        ApplicationCoverageReport report = (ApplicationCoverageReport)Mockito.mock(ApplicationCoverageReport.class);
        Mockito.when((Object)report.getCoverage()).thenReturn((Object)30.0);
        MuleLocation coveredLocation = (MuleLocation)Mockito.mock(MuleLocation.class);
        Mockito.when((Object)coveredLocation.getLineNumber()).thenReturn((Object)1);
        MuleLocation location = (MuleLocation)Mockito.mock(MuleLocation.class);
        Mockito.when((Object)location.getLineNumber()).thenReturn((Object)2);
        MuleFlow flow = (MuleFlow)Mockito.mock(MuleFlow.class);
        Mockito.when((Object)flow.getCoverage()).thenReturn((Object)30.0);
        Mockito.when((Object)flow.getCoveredLocations()).thenReturn(Collections.singletonList(coveredLocation));
        Mockito.when((Object)flow.getLocations()).thenReturn(Arrays.asList(coveredLocation, location));
        MuleResource resource = (MuleResource)Mockito.mock(MuleResource.class);
        Mockito.when((Object)resource.getFlows()).thenReturn(Collections.singletonList(flow));
        Mockito.when((Object)resource.getCoverage()).thenReturn((Object)30.0);
        Mockito.when((Object)resource.getName()).thenReturn((Object)"test.xml");
        Mockito.when((Object)report.getResources()).thenReturn(Collections.singletonList(resource));
        this.printer.printReport(report);
        Assert.assertEquals((Object)true, (Object)this.reportFile.exists());
        XStream xStream = new XStream();
        xStream.alias("coverage", SonarCoverage.class);
        xStream.autodetectAnnotations(true);
        SonarCoverage sonarCoverage = (SonarCoverage)xStream.fromXML(this.reportFile);
        Assert.assertNotNull((Object)sonarCoverage);
        Assert.assertEquals((Object)true, (Object)((SonarLineToCover)((SonarFile)sonarCoverage.getFiles().get(0)).getLinesToCover().get(0)).isCovered());
        Assert.assertEquals((long)1L, (long)((SonarLineToCover)((SonarFile)sonarCoverage.getFiles().get(0)).getLinesToCover().get(0)).getLineNumber());
        Assert.assertEquals((Object)false, (Object)((SonarLineToCover)((SonarFile)sonarCoverage.getFiles().get(0)).getLinesToCover().get(1)).isCovered());
        Assert.assertEquals((long)2L, (long)((SonarLineToCover)((SonarFile)sonarCoverage.getFiles().get(0)).getLinesToCover().get(1)).getLineNumber());
    }
}

