/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.printer.model;

import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleFlowLine;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.printer.model.MuleFlowModel;

public class MuleFlowModelTest {
    private MuleFlow testFlow;
    private MuleFlowModel flowModel;

    @Before
    public void setUp() {
        this.testFlow = new MuleFlow("testFlow");
        Vector<MuleLocation> locations = new Vector<MuleLocation>();
        locations.add(new MuleLocation("path", Integer.valueOf(1)));
        locations.add(new MuleLocation("path2", Integer.valueOf(2)));
        this.testFlow.setLocations(locations);
        Vector<MuleLocation> coveredLocations = new Vector<MuleLocation>();
        coveredLocations.add(new MuleLocation("path", Integer.valueOf(1)));
        this.testFlow.setLocations(coveredLocations);
        this.flowModel = new MuleFlowModel(this.testFlow);
    }

    @Test
    public void getFlowLines() {
        Vector<Integer> coveredLines = new Vector<Integer>();
        for (MuleLocation coveredLocation : this.testFlow.getCoveredLocations()) {
            coveredLines.add(coveredLocation.getLineNumber());
        }
        for (MuleFlowLine line : this.flowModel.getLines()) {
            if (coveredLines.contains(line.getLineNumber())) {
                Assert.assertEquals((Object)true, (Object)line.isCovered());
                continue;
            }
            Assert.assertEquals((Object)false, (Object)line.isCovered());
        }
    }

    @Test
    public void construction() {
        Assert.assertEquals((double)this.testFlow.getCoverage(), (double)this.flowModel.getCoverage(), (double)0.0);
        Assert.assertEquals((Object)this.testFlow.getName(), (Object)this.flowModel.getName());
        Assert.assertEquals((Object)this.testFlow.getType(), (Object)this.flowModel.getType());
        Assert.assertEquals((long)this.testFlow.getLocations().size(), (long)this.flowModel.getProcessorCount());
        Assert.assertEquals((long)this.testFlow.getCoveredLocations().size(), (long)this.flowModel.getMessageProcessorCount());
        Assert.assertEquals((long)this.testFlow.getLocations().size(), (long)this.flowModel.getLines().size());
    }
}

