/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import java.util.Collections;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.plugins.coverage.server.CoverageLocations;
import org.mule.munit.plugins.coverage.server.CoverageServerClient;

public class CoverageServerClientTest {
    @Test(expected=NullPointerException.class)
    public void constructionNullPort() {
        new CoverageServerClient(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructionNegativePort() {
        new CoverageServerClient(Integer.valueOf(-1));
    }

    @Test(expected=NullPointerException.class)
    public void validateSendReportNullReport() {
        new CoverageServerClient(Integer.valueOf(1)).sendCoveredLocations(null);
    }

    @Test
    public void validateSendReport() {
        CoverageLocations report = new CoverageLocations(Collections.emptySet());
        CoverageServerClient clientMock = (CoverageServerClient)Mockito.mock(CoverageServerClient.class);
        ((CoverageServerClient)Mockito.doCallRealMethod().when((Object)clientMock)).sendCoveredLocations(report);
        clientMock.sendCoveredLocations(report);
        ((CoverageServerClient)Mockito.verify((Object)clientMock, (VerificationMode)Mockito.times((int)1))).reportToJson(report);
        ((CoverageServerClient)Mockito.verify((Object)clientMock, (VerificationMode)Mockito.times((int)1))).send(Matchers.anyString());
    }
}

