/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.server.CoverageLocations;
import org.mule.munit.plugins.coverage.server.CoverageLocationsAccumulator;
import org.mule.munit.plugins.coverage.server.CoverageServer;
import org.mule.munit.plugins.coverage.server.CoverageServerClient;

public class CoverageServerTest {
    private static final long MAX_WAIT = 20000L;
    private Boolean startedRun = false;
    private Integer port;

    @Before
    public void setUp() {
        this.port = new FreePortFinder(1, 65000).find();
    }

    @Test(expected=NullPointerException.class)
    public void constructNullPort() throws InterruptedException {
        TestCoverageLocationsAccumulator accumulator = new TestCoverageLocationsAccumulator();
        new CoverageServer(null, (CoverageLocationsAccumulator)accumulator);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructInvalidPort() throws InterruptedException {
        TestCoverageLocationsAccumulator accumulator = new TestCoverageLocationsAccumulator();
        new CoverageServer(Integer.valueOf(0), (CoverageLocationsAccumulator)accumulator);
    }

    @Test(expected=NullPointerException.class)
    public void constructNullAccumulator() throws InterruptedException {
        new CoverageServer(this.port, null);
    }

    @Test
    public void construct() throws InterruptedException {
        TestCoverageLocationsAccumulator accumulator = new TestCoverageLocationsAccumulator();
        CoverageServer coverageServer = new CoverageServer(this.port, (CoverageLocationsAccumulator)accumulator);
        MatcherAssert.assertThat((Object)coverageServer.isRunning(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)coverageServer.getPort(), (Matcher)Is.is((Object)this.port));
    }

    @Test
    public void accumulate() throws InterruptedException {
        CoverageLocations coverageLocations = this.getCoveredLocations();
        CoverageServerClient client = new CoverageServerClient(this.port);
        TestCoverageLocationsAccumulator accumulator = new TestCoverageLocationsAccumulator();
        CoverageServer coverageServer = new CoverageServer(this.port, (CoverageLocationsAccumulator)accumulator);
        coverageServer.launch();
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(() -> ((CoverageServer)coverageServer).isRunning());
        MatcherAssert.assertThat((Object)coverageServer.isRunning(), (Matcher)Is.is((Object)true));
        client.sendCoveredLocations(coverageLocations);
        coverageServer.shutDown();
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(() -> !coverageServer.isRunning());
        MatcherAssert.assertThat((Object)coverageServer.isRunning(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)accumulator.locationsList.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)accumulator.locationsList.get(0).getCoverageLocations(), (Matcher)Is.is((Object)coverageLocations.getCoverageLocations()));
    }

    private CoverageLocations getCoveredLocations() {
        HashSet<CoverageComponentLocation> componentLocations = new HashSet<CoverageComponentLocation>();
        CoverageComponentLocation location = CoverageComponentLocation.fromSingleComponent((String)"mule:logger");
        componentLocations.add(location);
        return new CoverageLocations(componentLocations);
    }

    private static class TestCoverageLocationsAccumulator
    implements CoverageLocationsAccumulator {
        List<CoverageLocations> locationsList = new ArrayList<CoverageLocations>();

        private TestCoverageLocationsAccumulator() {
        }

        public void accumulateCoverageLocations(CoverageLocations coverageLocations) {
            this.locationsList.add(coverageLocations);
        }
    }
}

