/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationUtils {
    public static final String MULE = "mule";
    public static final String FOREACH = "foreach";
    public static final String PROCESSORS = "processors";
    public static final String LOGGER = "logger";
    public static final String FLOW_REF = "flow-ref";
    public static final String SET_PAYLOAD = "set-payload";

    public static ComponentLocation componentLocation(String namespace, String name, TypedComponentIdentifier.ComponentType type, String idx, List<DefaultComponentLocation.DefaultLocationPart> parts) {
        return ComponentLocationUtils.componentLocation(namespace, name, type, idx, Optional.empty(), Optional.empty(), parts);
    }

    public static ComponentLocation componentLocation(String namespace, String name, TypedComponentIdentifier.ComponentType type, String idx, Optional<String> fileName, Optional<Integer> lineNumber, List<DefaultComponentLocation.DefaultLocationPart> parts) {
        TypedComponentIdentifier identifier = ComponentLocationUtils.buildComponentIdentifier(namespace, name, type);
        parts.add(new DefaultComponentLocation.DefaultLocationPart(idx, Optional.of(identifier), fileName, lineNumber));
        DefaultComponentLocation location = new DefaultComponentLocation(Optional.of(name), parts);
        return location;
    }

    public static DefaultComponentLocation.DefaultLocationPart flowPart(String name) {
        TypedComponentIdentifier identifier = ComponentLocationUtils.buildComponentIdentifier(MULE, "flow", TypedComponentIdentifier.ComponentType.FLOW);
        return new DefaultComponentLocation.DefaultLocationPart(name, Optional.ofNullable(identifier), Optional.empty(), Optional.empty());
    }

    public static DefaultComponentLocation.DefaultLocationPart flowPart(String name, String fileName, Integer lineNumber) {
        TypedComponentIdentifier identifier = ComponentLocationUtils.buildComponentIdentifier(MULE, "flow", TypedComponentIdentifier.ComponentType.FLOW);
        return new DefaultComponentLocation.DefaultLocationPart(name, Optional.ofNullable(identifier), Optional.ofNullable(fileName), Optional.ofNullable(lineNumber));
    }

    public static DefaultComponentLocation.DefaultLocationPart forEachPart(String idx) {
        TypedComponentIdentifier identifier = ComponentLocationUtils.buildComponentIdentifier(MULE, FOREACH, TypedComponentIdentifier.ComponentType.SCOPE);
        return new DefaultComponentLocation.DefaultLocationPart(idx, Optional.ofNullable(identifier), Optional.empty(), Optional.empty());
    }

    public static DefaultComponentLocation.DefaultLocationPart processorsPart() {
        return ComponentLocationUtils.processorsPart(Optional.empty(), Optional.empty());
    }

    public static DefaultComponentLocation.DefaultLocationPart processorsPart(Optional<String> fileName, Optional<Integer> lineNumber) {
        return new DefaultComponentLocation.DefaultLocationPart(PROCESSORS, Optional.empty(), fileName, lineNumber);
    }

    public static TypedComponentIdentifier buildComponentIdentifier(String namespace, String name, TypedComponentIdentifier.ComponentType type) {
        return TypedComponentIdentifier.builder().type(type).identifier(ComponentIdentifier.buildFromStringRepresentation((String)(namespace + ":" + name))).build();
    }

    public static List<DefaultComponentLocation.DefaultLocationPart> asListOfParts(DefaultComponentLocation.DefaultLocationPart ... parts) {
        ArrayList<DefaultComponentLocation.DefaultLocationPart> listOfParts = new ArrayList<DefaultComponentLocation.DefaultLocationPart>();
        for (DefaultComponentLocation.DefaultLocationPart part : parts) {
            listOfParts.add(part);
        }
        return listOfParts;
    }
}

