/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentIdentifier;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.core.model.CoverageLocationPart;
import org.mule.munit.plugins.coverage.core.model.CoverageTypedComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;

public class CoverageComponentLocationUtils {
    public static final String MULE = "mule";
    public static final String FOREACH = "foreach";
    public static final String CHOICE = "choice";
    public static final String ERROR_HANDLER = "error_handler";
    public static final String PROCESSORS = "processors";
    public static final String ROUTE = "route";
    public static final String LOGGER = "logger";
    public static final String FLOW_REF = "flow-ref";
    public static final String SET_PAYLOAD = "set-payload";
    public static final String A_FLOW = "aFlow";
    public static final String A_SUB_FLOW = "aSubFlow";
    public static final String A_FLOW_WITH_FOR_EACH = "aFlowWithForEach";
    public static final String TOM_FLOW = "tomFlow";
    public static final String PAUL_SUB_FLOW = "paulSubFlow";
    public static final String A_FLOW_WITH_ERROR_HANDLING = "aFlowWithErrorHandling";
    public static final String A_FLOW_WITH_CHOICE = "aFlowWithChoice";
    public static final String FAKE_NAMESPACE = "fakenamespace";
    public static final String FAKE_PROCESSOR_NAME = "processorname";
    public static final String FILE_ONE = "file-one.xml";
    public static final String FILE_TWO = "file-two.xml";
    public static final String FILE_THREE = "file-three.xml";

    public static Integer getFileCount() {
        return 3;
    }

    public static Set<CoverageComponentLocation> getAllLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        locations.addAll(CoverageComponentLocationUtils.getFileOneLocationSet());
        locations.addAll(CoverageComponentLocationUtils.getFileTwoLocationSet());
        locations.addAll(CoverageComponentLocationUtils.getFileThreeLocationSet());
        return locations;
    }

    public static Set<String> getAllFilesFlowNames() {
        HashSet<String> flowNames = new HashSet<String>();
        flowNames.addAll(CoverageComponentLocationUtils.getFileOneFlowNames());
        flowNames.addAll(CoverageComponentLocationUtils.getFileTwoFlowNames());
        flowNames.addAll(CoverageComponentLocationUtils.getFileThreeFlowNames());
        return flowNames;
    }

    public static Set<CoverageComponentLocation> getFileOneLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        locations.addAll(CoverageComponentLocationUtils.getAFLowLocationSet());
        locations.addAll(CoverageComponentLocationUtils.getASubFlowLocationSet());
        locations.addAll(CoverageComponentLocationUtils.getAFlowWithForEachLocationSet());
        return locations;
    }

    public static Set<String> getFileOneFlowNames() {
        return Sets.newHashSet((Object[])new String[]{A_FLOW, A_SUB_FLOW, A_FLOW_WITH_FOR_EACH});
    }

    public static Set<CoverageComponentLocation> getFileTwoLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        locations.addAll(CoverageComponentLocationUtils.getTomFLowLocationSet());
        locations.addAll(CoverageComponentLocationUtils.getPaulSubFlowLocationSet());
        return locations;
    }

    public static Set<String> getFileTwoFlowNames() {
        return Sets.newHashSet((Object[])new String[]{TOM_FLOW, PAUL_SUB_FLOW});
    }

    public static Set<CoverageComponentLocation> getFileThreeLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        locations.addAll(CoverageComponentLocationUtils.getAFlowWithErrorHandlingLocationSet());
        locations.addAll(CoverageComponentLocationUtils.getAFlowWithChoiceLocationSet());
        return locations;
    }

    public static Set<String> getFileThreeFlowNames() {
        return Sets.newHashSet((Object[])new String[]{A_FLOW_WITH_ERROR_HANDLING, A_FLOW_WITH_CHOICE});
    }

    public static Set<CoverageComponentLocation> getAFLowLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(A_FLOW, FILE_ONE, 0);
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_ONE), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, FLOW_REF, TypedComponentIdentifier.ComponentType.OPERATION, "1", Optional.of(FILE_ONE), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, FLOW_REF, TypedComponentIdentifier.ComponentType.OPERATION, "2", Optional.of(FILE_ONE), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "3", Optional.of(FILE_ONE), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        return locations;
    }

    public static Set<CoverageComponentLocation> getASubFlowLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(A_SUB_FLOW, FILE_ONE, 15);
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_ONE), Optional.of(12), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(FAKE_NAMESPACE, FAKE_PROCESSOR_NAME, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_ONE), Optional.of(12), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        return locations;
    }

    public static Set<CoverageComponentLocation> getAFlowWithForEachLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(A_FLOW_WITH_FOR_EACH, FILE_ONE, 16);
        CoverageLocationPart forEachPart = CoverageComponentLocationUtils.forEachPart("1");
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_ONE), Optional.of(16), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_ONE), Optional.of(20), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart(), forEachPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "1", Optional.of(FILE_ONE), Optional.of(20), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart(), forEachPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, FLOW_REF, TypedComponentIdentifier.ComponentType.OPERATION, "2", Optional.of(FILE_ONE), Optional.of(16), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        return locations;
    }

    public static Set<CoverageComponentLocation> getTomFLowLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(TOM_FLOW, FILE_TWO, 0);
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_TWO), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, FLOW_REF, TypedComponentIdentifier.ComponentType.OPERATION, "1", Optional.of(FILE_TWO), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, FLOW_REF, TypedComponentIdentifier.ComponentType.OPERATION, "2", Optional.of(FILE_TWO), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "3", Optional.of(FILE_TWO), Optional.of(0), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        return locations;
    }

    public static Set<CoverageComponentLocation> getPaulSubFlowLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(PAUL_SUB_FLOW, FILE_TWO, 15);
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_TWO), Optional.of(12), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        locations.add(CoverageComponentLocationUtils.componentLocation(FAKE_NAMESPACE, FAKE_PROCESSOR_NAME, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_TWO), Optional.of(12), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        return locations;
    }

    public static Set<CoverageComponentLocation> getAFlowWithErrorHandlingLocationSet() {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(A_FLOW_WITH_ERROR_HANDLING, FILE_THREE, 24);
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_THREE), Optional.of(16), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        CoverageLocationPart errorHandlerPart = CoverageComponentLocationUtils.errorHandlerPart("1");
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_THREE), Optional.of(20), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart(), errorHandlerPart, CoverageComponentLocationUtils.processorsPart())));
        return locations;
    }

    public static Set<CoverageComponentLocation> getAFlowWithChoiceLocationSet() {
        return CoverageComponentLocationUtils.getAFlowWithChoiceLocationSet(true);
    }

    public static Set<CoverageComponentLocation> getAFlowWithChoiceLocationSet(Boolean coverOtherwise) {
        HashSet<CoverageComponentLocation> locations = new HashSet<CoverageComponentLocation>();
        CoverageLocationPart flowPart = CoverageComponentLocationUtils.flowPart(A_FLOW_WITH_CHOICE, FILE_THREE, 24);
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, SET_PAYLOAD, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_THREE), Optional.of(16), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart())));
        CoverageLocationPart choicePart = CoverageComponentLocationUtils.choicePart("1");
        locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of(FILE_THREE), Optional.of(20), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart(), choicePart, CoverageComponentLocationUtils.routePart(), CoverageComponentLocationUtils.processorsPart())));
        if (coverOtherwise.booleanValue()) {
            locations.add(CoverageComponentLocationUtils.componentLocation(MULE, LOGGER, TypedComponentIdentifier.ComponentType.OPERATION, "1", Optional.of(FILE_THREE), Optional.of(20), CoverageComponentLocationUtils.asListOfParts(flowPart, CoverageComponentLocationUtils.processorsPart(), choicePart, CoverageComponentLocationUtils.routePart(), CoverageComponentLocationUtils.processorsPart())));
        }
        return locations;
    }

    public static CoverageComponentLocation componentLocation(String namespace, String name, TypedComponentIdentifier.ComponentType type, String idx, List<CoverageLocationPart> parts) {
        return CoverageComponentLocationUtils.componentLocation(namespace, name, type, idx, Optional.empty(), Optional.empty(), parts);
    }

    public static CoverageComponentLocation componentLocation(String namespace, String name, TypedComponentIdentifier.ComponentType type, String idx, Optional<String> fileName, Optional<Integer> lineNumber, List<CoverageLocationPart> parts) {
        CoverageTypedComponentIdentifier identifier = CoverageComponentLocationUtils.buildComponentIdentifier(namespace, name, type);
        parts.add(new CoverageLocationPart(idx, Optional.of(identifier), fileName, lineNumber));
        CoverageComponentLocation location = new CoverageComponentLocation(Optional.of(name), parts);
        return location;
    }

    public static CoverageLocationPart flowPart(String name) {
        CoverageTypedComponentIdentifier identifier = CoverageComponentLocationUtils.buildComponentIdentifier(MULE, "flow", TypedComponentIdentifier.ComponentType.FLOW);
        return new CoverageLocationPart(name, Optional.of(identifier), Optional.empty(), Optional.empty());
    }

    public static CoverageLocationPart flowPart(String name, String fileName, Integer lineNumber) {
        CoverageTypedComponentIdentifier identifier = CoverageComponentLocationUtils.buildComponentIdentifier(MULE, "flow", TypedComponentIdentifier.ComponentType.FLOW);
        return new CoverageLocationPart(name, Optional.of(identifier), Optional.of(fileName), Optional.of(lineNumber));
    }

    public static CoverageLocationPart forEachPart(String idx) {
        CoverageTypedComponentIdentifier identifier = CoverageComponentLocationUtils.buildComponentIdentifier(MULE, FOREACH, TypedComponentIdentifier.ComponentType.SCOPE);
        return new CoverageLocationPart(idx, Optional.of(identifier), Optional.empty(), Optional.empty());
    }

    public static CoverageLocationPart errorHandlerPart(String idx) {
        CoverageTypedComponentIdentifier identifier = CoverageComponentLocationUtils.buildComponentIdentifier(MULE, ERROR_HANDLER, TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
        return new CoverageLocationPart(idx, Optional.of(identifier), Optional.empty(), Optional.empty());
    }

    public static CoverageLocationPart choicePart(String idx) {
        CoverageTypedComponentIdentifier identifier = CoverageComponentLocationUtils.buildComponentIdentifier(MULE, CHOICE, TypedComponentIdentifier.ComponentType.ROUTER);
        return new CoverageLocationPart(idx, Optional.of(identifier), Optional.empty(), Optional.empty());
    }

    public static CoverageLocationPart routePart() {
        return CoverageComponentLocationUtils.routePart(Optional.empty(), Optional.empty());
    }

    public static CoverageLocationPart routePart(Optional<String> fileName, Optional<Integer> lineNumber) {
        return new CoverageLocationPart(ROUTE, Optional.empty(), fileName, lineNumber);
    }

    public static CoverageLocationPart processorsPart() {
        return CoverageComponentLocationUtils.processorsPart(Optional.empty(), Optional.empty());
    }

    public static CoverageLocationPart processorsPart(Optional<String> fileName, Optional<Integer> lineNumber) {
        return new CoverageLocationPart(PROCESSORS, Optional.empty(), fileName, lineNumber);
    }

    public static CoverageTypedComponentIdentifier buildComponentIdentifier(String namespace, String name, TypedComponentIdentifier.ComponentType type) {
        return new CoverageTypedComponentIdentifier(CoverageComponentIdentifier.parseComponentIdentifier((String)(namespace + ":" + name)), type);
    }

    public static List<CoverageLocationPart> asListOfParts(CoverageLocationPart ... parts) {
        ArrayList<CoverageLocationPart> listOfParts = new ArrayList<CoverageLocationPart>();
        for (CoverageLocationPart part : parts) {
            listOfParts.add(part);
        }
        return listOfParts;
    }
}

