/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.printer.model.sonar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

/**
 * <p>
 * Model to represent the line to cover in the xml Sonar report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
@XStreamAlias(value = "lineToCover")
public class SonarLineToCover {

  @XStreamAsAttribute
  private int lineNumber;

  @XStreamAsAttribute
  private boolean covered;

  @XStreamAsAttribute
  private Integer branchesToCover;

  @XStreamAsAttribute
  private Integer coveredBranches;

  public SonarLineToCover(int lineNumber, boolean covered) {
    this.lineNumber = lineNumber;
    this.covered = covered;
  }

  public SonarLineToCover(int lineNumber) {
    this(lineNumber, false);
  }

  public int getLineNumber() {
    return lineNumber;
  }

  public boolean isCovered() {
    return covered;
  }
}
