/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;

public class MuleResource {
    private String name;
    private Double weight = null;
    private List<MuleFlow> flows = new ArrayList<MuleFlow>();
    private Double branchCoverage = null;

    public MuleResource(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"The name must not be null nor empty.");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Double getWeight() {
        return this.weight;
    }

    public List<MuleFlow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<MuleFlow> flows) {
        Preconditions.checkNotNull(flows, (Object)"The flows list must not be null.");
        this.flows = new ArrayList<MuleFlow>(flows);
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public String getWeightFormatted() {
        return String.format("%.2f", this.weight);
    }

    public Double getCoverage() {
        int resourcePathCount = 0;
        int resourceCoveredPathCount = 0;
        for (MuleFlow flow : this.flows) {
            resourcePathCount += flow.getLocations().size();
            resourceCoveredPathCount += flow.getCoveredLocations().size();
        }
        if (resourcePathCount > 0) {
            return Double.valueOf(resourceCoveredPathCount) * 100.0 / Double.valueOf(resourcePathCount);
        }
        return -1.0;
    }

    public Integer getMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : this.flows) {
            count = count + mf.getLocations().size();
        }
        return count;
    }

    public Integer getCoveredMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : this.flows) {
            count = count + mf.getCoveredLocations().size();
        }
        return count;
    }
}

