/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.core.model;


import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;

import java.io.Serializable;
import java.util.Optional;

import static org.mule.munit.plugins.coverage.core.model.CoverageComponentIdentifier.CORE_PREFIX;
import static org.mule.munit.plugins.coverage.core.model.CoverageComponentIdentifier.fromComponentIdentifier;


/**
 * Descriptor for a component in the configuration along with it's {@link ComponentType}.
 * 
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class CoverageTypedComponentIdentifier implements TypedComponentIdentifier, Serializable {

  private static final long serialVersionUID = -6585884125494525933L;

  private CoverageComponentIdentifier identifier;
  private ComponentType type;

  public CoverageTypedComponentIdentifier(CoverageComponentIdentifier identifier, ComponentType type) {
    this.identifier = identifier;
    this.type = type;
  }

  public ComponentIdentifier getIdentifier() {
    return identifier;
  }

  public ComponentType getType() {
    return type;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    CoverageTypedComponentIdentifier that = (CoverageTypedComponentIdentifier) o;

    if (!getIdentifier().equals(that.getIdentifier())) {
      return false;
    }
    return getType() == that.getType();
  }

  @Override
  public int hashCode() {
    int result = getIdentifier().hashCode();
    result = 31 * result + getType().hashCode();
    return result;
  }

  @Override
  public String toString() {
    return "CoverageTypedComponentIdentifier{" +
        "identifier=" + identifier +
        ", type=" + type +
        '}';
  }


  public static Optional<CoverageTypedComponentIdentifier> fromTypedComponentIdentifier(Optional<TypedComponentIdentifier> identifier) {
    if (identifier.isPresent()) {
      return Optional.of(fromTypedComponentIdentifier(identifier.get()));
    }
    return Optional.empty();
  }


  public static CoverageTypedComponentIdentifier fromTypedComponentIdentifier(TypedComponentIdentifier identifier) {
    return new CoverageTypedComponentIdentifier(fromComponentIdentifier(identifier.getIdentifier()), identifier.getType());
  }

}
