/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.server;

import org.mule.munit.common.util.Preconditions;

import java.io.Serializable;
import java.util.Set;

import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;

/**
 * Report to inform a set of location  CoverageComponentLocation
 *
 * It can be used to send locations:
 *
 *
 * - informed due to them being reported as covered
 *
 * - informed due to them composing an application
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class CoverageLocations implements Serializable {

  private static final long serialVersionUID = 42L;

  private Boolean allLocations = Boolean.FALSE;
  private Set<CoverageComponentLocation> coverageLocations;

  public CoverageLocations(Set<CoverageComponentLocation> coverageLocations) {
    Preconditions.checkNotNull(coverageLocations, "The covered locations must not be null");
    this.coverageLocations = coverageLocations;
  }

  public Boolean isAllLocations() {
    return allLocations;
  }

  public void setAllLocations(Boolean allLocations) {
    this.allLocations = allLocations;
  }

  public Set<CoverageComponentLocation> getCoverageLocations() {
    return coverageLocations;
  }

}
