/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.plugins.coverage.server.CoverageLocations;

public class CoverageServerClient {
    private static final String DEFAULT_HOST = "localhost";
    private transient Log logger = LogFactory.getLog(this.getClass());
    private Integer serverPort;

    public CoverageServerClient(Integer serverPort) {
        Preconditions.checkNotNull((Object)serverPort, (String)"The server port must not be null.");
        Preconditions.checkArgument((serverPort > 0 ? 1 : 0) != 0, (String)"The server port must be a positive number.");
        this.serverPort = serverPort;
    }

    public void sendCoveredLocations(CoverageLocations report) {
        Preconditions.checkNotNull((Object)report, (String)"The report must not be null.");
        this.send(this.reportToJson(report));
    }

    public String reportToJson(CoverageLocations report) {
        Gson gson = new Gson();
        return gson.toJson((Object)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String report) {
        this.logger.info((Object)"Sending covered locations report...");
        Socket requestSocket = null;
        ObjectOutputStream out = null;
        try {
            requestSocket = new Socket(DEFAULT_HOST, (int)this.serverPort);
            this.logger.info((Object)("Connected to localhost in port " + this.serverPort));
            out = new ObjectOutputStream(requestSocket.getOutputStream());
            out.writeObject(report);
            out.flush();
            this.logger.debug((Object)"Covered locations report sent");
        }
        catch (IOException ioException) {
            this.logger.error((Object)"Fail to send covered locations report");
            ioException.printStackTrace();
        }
        finally {
            this.logger.debug((Object)("Shutting down " + this.getClass().getName()));
            try {
                if (out != null) {
                    out.close();
                }
                if (requestSocket != null) {
                    requestSocket.close();
                }
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }
}

