/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.extensions;

import com.mulesoft.mule.plugin.ManagedMulePlugin;
import com.mulesoft.mule.plugin.classloader.ClassLoaderFilter;
import com.mulesoft.mule.plugin.classloader.FileSystemPluginClassLoaderFactory;
import com.mulesoft.mule.plugin.classloader.FilteringPluginClassLoader;
import com.mulesoft.mule.plugin.classloader.PluginClassLoaderFactory;
import com.mulesoft.mule.plugin.classloader.PluginClassLoaderFilter;
import com.mulesoft.mule.plugin.discoverer.FileSystemPluginDiscoverer;
import com.mulesoft.mule.plugin.discoverer.PluginDiscoverer;
import com.mulesoft.mule.plugin.factory.MulePluginConfigurerFactory;
import com.mulesoft.mule.plugin.factory.MulePluginFactory;
import com.mulesoft.mule.plugin.factory.MulePluginPropertyDiscovererFactory;
import com.mulesoft.mule.plugin.factory.PluginConfigurerFactory;
import com.mulesoft.mule.plugin.factory.PluginFactory;
import com.mulesoft.mule.plugin.factory.PluginPropertyDiscovererFactory;
import com.mulesoft.mule.plugin.manager.MulePluginManagerFactory;
import com.mulesoft.mule.plugin.manager.PluginManager;
import com.mulesoft.mule.plugin.manager.PluginRegistrationListener;
import com.mulesoft.mule.plugin.processor.CompositePluginProcessor;
import com.mulesoft.mule.plugin.processor.PluginProcessor;
import com.mulesoft.mule.plugin.processor.deployment.DeploymentListenerProvider;
import com.mulesoft.mule.plugin.processor.deployment.DeploymentListenerProviderProcessor;
import com.mulesoft.mule.plugin.processor.deployment.DeploymentServiceAwareProcessor;
import java.io.File;
import java.io.IOException;
import org.mule.MuleCoreExtension;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.launcher.DeploymentListenerManager;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.PluginClassLoaderManagerAware;
import org.mule.munit.plugins.coverage.extensions.CompositePluginDiscoverer;
import org.mule.util.FileUtils;

public class MunitPluginCoreExtension
implements MuleCoreExtension,
DeploymentServiceAware,
PluginClassLoaderManagerAware,
PluginRegistrationListener {
    public static final String PLUGINS_DIR = "mule-plugins";
    private PluginManager pluginManager;
    private DeploymentService deploymentService;
    private PluginClassLoaderManager pluginClassLoaderManager;

    private static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public void dispose() {
        if (this.pluginManager != null) {
            this.pluginManager.dispose();
        }
    }

    public void initialise() throws InitialisationException {
        this.pluginManager = this.createDefaultPluginManager();
        this.pluginManager.initialise();
        for (ManagedMulePlugin plugin : this.pluginManager.registeredPlugins()) {
            if (!(plugin.getPlugin() instanceof DeploymentListenerProvider)) continue;
            this.deploymentService.addDeploymentListener(((DeploymentListenerProvider)plugin.getPlugin()).getDeploymentListener());
        }
    }

    private PluginProcessor createDefaultPluginProcessor() {
        CompositePluginProcessor compositePluginProcessor = new CompositePluginProcessor();
        if (this.deploymentService != null) {
            compositePluginProcessor.addProcessor((PluginProcessor)new DeploymentListenerProviderProcessor((DeploymentListenerManager)this.deploymentService));
            compositePluginProcessor.addProcessor((PluginProcessor)new DeploymentServiceAwareProcessor(this.deploymentService));
        }
        return compositePluginProcessor;
    }

    private PluginManager createDefaultPluginManager() {
        File debugerTempFolder;
        CompositePluginDiscoverer pluginDiscoverer = new CompositePluginDiscoverer();
        File pluginsFolder = this.getUserPluginFolder();
        if (pluginsFolder != null) {
            pluginDiscoverer.addDiscoverer((PluginDiscoverer)new FileSystemPluginDiscoverer(pluginsFolder));
        }
        if ((debugerTempFolder = this.createDebuggerPluginTempFolder("mule.debug.enable", "mule-plugin-debugger.zip")) != null) {
            pluginDiscoverer.addDiscoverer((PluginDiscoverer)new FileSystemPluginDiscoverer(debugerTempFolder));
        }
        PluginFactory pluginFactory = this.createDefaultPluginFactory();
        MulePluginManagerFactory pluginManagerFactory = new MulePluginManagerFactory((PluginDiscoverer)pluginDiscoverer, pluginFactory);
        pluginManagerFactory.addPluginRegistrationListener((PluginRegistrationListener)this);
        PluginProcessor pluginProcessor = this.createDefaultPluginProcessor();
        pluginManagerFactory.setPluginProcessor(pluginProcessor);
        return pluginManagerFactory.create();
    }

    public String getName() {
        return "Mule Plugin Core Extension";
    }

    public void start() throws MuleException {
        this.pluginManager.start();
    }

    public void stop() throws MuleException {
        this.pluginManager.stop();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setPluginClassLoaderManager(PluginClassLoaderManager pluginClassLoaderManager) {
        this.pluginClassLoaderManager = pluginClassLoaderManager;
    }

    public void onPluginRegistered(ManagedMulePlugin plugin) {
        ClassLoader pluginClassLoader = plugin.getPlugin().getClass().getClassLoader();
        PluginClassLoaderFilter filter = new PluginClassLoaderFilter(plugin.getDescriptor());
        FilteringPluginClassLoader filteringPluginClassLoader = new FilteringPluginClassLoader(plugin.getName(), pluginClassLoader, (ClassLoaderFilter)filter);
        this.pluginClassLoaderManager.addPluginClassLoader((ClassLoader)filteringPluginClassLoader);
    }

    private File getUserPluginFolder() {
        File pluginsFolder = new File(this.getClass().getClassLoader().getResource("").getPath(), PLUGINS_DIR);
        if (!pluginsFolder.exists()) {
            return null;
        }
        return pluginsFolder;
    }

    private PluginFactory createDefaultPluginFactory() {
        return new MulePluginFactory((PluginClassLoaderFactory)new FileSystemPluginClassLoaderFactory(), (PluginPropertyDiscovererFactory)new MulePluginPropertyDiscovererFactory(), (PluginConfigurerFactory)new MulePluginConfigurerFactory());
    }

    private File createDebuggerPluginTempFolder(String enableCondition, String resourceName) {
        if (Boolean.getBoolean(enableCondition)) {
            try {
                File tempDirectory = MunitPluginCoreExtension.createTempDirectory();
                FileUtils.extractResources((String)resourceName, this.getClass(), (File)tempDirectory, (boolean)true);
                return tempDirectory;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

