/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.extensions;

import com.mulesoft.mule.plugin.discoverer.PluginDiscoverer;
import com.mulesoft.mule.plugin.factory.PluginDescriptor;

import java.util.ArrayList;
import java.util.List;


public class CompositePluginDiscoverer implements PluginDiscoverer
{

    List<PluginDiscoverer> discoverers = new ArrayList<PluginDiscoverer>();

    @Override
    public List<PluginDescriptor> discover()
    {
        List<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>();
        for ( PluginDiscoverer pluginDiscoverer : discoverers){
            descriptors.addAll(pluginDiscoverer.discover());
        }
        return descriptors;
    }

    public void addDiscoverer(PluginDiscoverer pluginDiscoverer){
        discoverers.add(pluginDiscoverer);
    }
}
