/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.extensions;


import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.launcher.MulePluginClassLoaderManager;
import org.mule.module.launcher.coreextension.DefaultMuleCoreExtensionManager;
import org.mule.module.launcher.coreextension.MuleCoreExtensionManager;
import org.mule.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.munit.common.extensions.MunitPlugin;

public class MunitMuleExtensionsLoaderPlugin  implements MunitPlugin, MuleContextAware
{

    public static final String APP_NAME = System.getProperty("munit.test.app.name", "appName");


    private MunitDeploymentService munitDeploymentService;
    private MuleCoreExtensionManager muleCoreExtensionManager;
    private MuleContext muleContext;


    public void dispose()
    {
        muleCoreExtensionManager.dispose();
    }

    public void initialise() throws InitialisationException
    {
        muleCoreExtensionManager = new DefaultMuleCoreExtensionManager(new MunitPluginDiscoverer(),
                                                                       new ReflectionMuleCoreExtensionDependencyResolver() );
        MulePluginClassLoaderManager pluginClassLoaderManager = new MulePluginClassLoaderManager();
        munitDeploymentService = new MunitDeploymentService(APP_NAME, muleContext);
        muleCoreExtensionManager.setDeploymentService(munitDeploymentService);
        muleCoreExtensionManager.setPluginClassLoaderManager(pluginClassLoaderManager);
        muleCoreExtensionManager.initialise();
        munitDeploymentService.start();
    }

    public void start() throws MuleException
    {
        muleCoreExtensionManager.start();
    }

    public void stop() throws MuleException
    {
        muleCoreExtensionManager.stop();
    }

    @Override
    public void setMuleContext(MuleContext muleContext)
    {
        this.muleContext = muleContext;
    }
}
