/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.extensions;

import org.mule.api.MuleContext;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.StartupListener;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.domain.Domain;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;


public class MunitDeploymentService implements DeploymentService {

    private Application munitApplication;

    private CompositeDeploymentListener deploymentListener = new CompositeDeploymentListener();

    public MunitDeploymentService(String applicationName, MuleContext muleContext) {
        munitApplication = new MunitTestApplication(muleContext, applicationName);
    }

    @Override
    public Application findApplication(String appName) {
        if (appName.equals(munitApplication.getArtifactName())) {
            return munitApplication;
        }
        return null;
    }

    @Override
    public List<Application> getApplications() {
        return Arrays.asList(new Application[]{munitApplication});
    }

    @Override
    public Domain findDomain(String s) {
        return null;
    }

    @Override
    public Collection<Application> findDomainApplications(String s) {
        return new ArrayList<Application>(getApplications());
    }

    @Override
    public List<Domain> getDomains() {
        return null;
    }

    @Override
    public void addStartupListener(StartupListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStartupListener(StartupListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReentrantLock getLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void undeploy(String appName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deploy(URL appArchiveUrl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deploy(URL url, Properties properties) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void redeploy(String s, Properties properties) {
    }

    @Override
    public void redeploy(String s) {
    }

    @Override
    public void start() {
        deploymentListener.onMuleContextCreated(munitApplication.getArtifactName(), munitApplication.getMuleContext());
        deploymentListener.onMuleContextConfigured(munitApplication.getArtifactName(), munitApplication.getMuleContext());
        deploymentListener.onMuleContextInitialised(munitApplication.getArtifactName(), munitApplication.getMuleContext());
        deploymentListener.onDeploymentSuccess(munitApplication.getArtifactName());
    }

    @Override
    public void stop() {

    }

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        deploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        deploymentListener.removeDeploymentListener(listener);
    }


    @Override
    public void addDomainDeploymentListener(DeploymentListener deploymentListener) {
    }

    @Override
    public void removeDomainDeploymentListener(DeploymentListener deploymentListener) {
    }

    @Override
    public void undeployDomain(String s) {
        throw new UnsupportedOperationException();

    }

    @Override
    public void deployDomain(URL url) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deployDomain(URL url, Properties properties) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void redeployDomain(String s) {
        throw new UnsupportedOperationException();
    }

    @Override public void redeployDomain(String s, Properties properties) {
        throw new UnsupportedOperationException();
    }
}
