/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.extensions;

import org.mule.api.MuleContext;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.InstallException;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationStatus;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.domain.Domain;

import java.io.File;
import java.util.Properties;

/**
 * <p>
 * Representation of the tested application for the {@link org.mule.MuleCoreExtension}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public class MunitTestApplication implements Application
{

    /**
     * <p>
     * The mule context of the application that is being tested.
     * </p>
     */
    private MuleContext muleContext;

    /**
     * <p>
     * The name of the application that is being tested
     * </p>
     */
    private String applicationName;

    public MunitTestApplication(MuleContext muleContext, String applicationName)
    {
        this.muleContext = muleContext;
        this.applicationName = applicationName;
    }

    @Override
    public void install() throws InstallException
    {
    }

    @Override
    public void init()
    {
    }

    @Override
    public void start() throws DeploymentStartException
    {
    }

    @Override
    public void stop()
    {
    }

    @Override
    public void dispose()
    {
    }

    @Override
    public String getArtifactName()
    {
        return applicationName;
    }

    @Override
    public File[] getResourceFiles()
    {
        return new File[0];
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader()
    {
        return null;
    }


    @Override
    public MuleContext getMuleContext()
    {
        return muleContext;
    }

    @Override
    public void setDeploymentProperties(Properties properties) {

    }

    @Override
    public ApplicationDescriptor getDescriptor()
    {
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor();
        applicationDescriptor.setName(applicationName);
        return applicationDescriptor;
    }

    @Override
    public Domain getDomain()
    {
        return null;
    }

    @Override
    public ApplicationStatus getStatus()
    {
        return null;
    }

	@Override
	public void cancelStart() {
		// TODO Auto-generated method stub
		
	}
}
