/**
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.munit.test.extension;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import static org.mule.runtime.api.connection.ConnectionValidationResult.success;
import static org.mule.runtime.api.meta.ExternalLibraryType.DEPENDENCY;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.ExternalLib;

@ExternalLib(name = "ActiveMQ Client",
  description = "Client Implementation.",
  type = DEPENDENCY,
  requiredClassName = SharedLibsConnectionProvider.ACTIVE_MQCONNECTION_FACTORY,
  coordinates = "org.apache.activemq:activemq-client:5.14.5")
@ExternalLib(name = "ActiveMQ Broker",
  description = "Broker Implementation",
  type = DEPENDENCY,
  requiredClassName = SharedLibsConnectionProvider.ACTIVEMQ_BROKER,
  coordinates = "org.apache.activemq:activemq-broker:5.14.5",
  optional = true)
public class SharedLibsConnectionProvider implements ConnectionProvider<SharedConnection> {

  public static final String ACTIVE_MQCONNECTION_FACTORY = "org.apache.activemq.ActiveMQConnectionFactory";
  public static final String ACTIVEMQ_BROKER = "org.apache.activemq.broker.Broker";

  private boolean connected;

  @Override
  public SharedConnection connect() throws ConnectionException {

    try {
      ClassUtils.loadClass(ACTIVE_MQCONNECTION_FACTORY, Thread.currentThread().getContextClassLoader());
    } catch (ClassNotFoundException e) {
      throw new ConnectionException("Failed to load required library class: " + ACTIVE_MQCONNECTION_FACTORY, e);
    }

    try {
      ClassUtils.loadClass(ACTIVEMQ_BROKER, Thread.currentThread().getContextClassLoader());
    } catch (ClassNotFoundException e) {
      throw new ConnectionException("Failed to load optional library class: " + ACTIVEMQ_BROKER, e);
    }

    return new SharedConnection();
  }

  @Override
  public void disconnect(SharedConnection connection) {
    connection.disconnect();
  }

  @Override
  public ConnectionValidationResult validate(SharedConnection connection) {
    return connection.isConnected() ? success() : failure("Connection was disconnected", new RuntimeException());
  }
  
}
