/**
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.munit.test.extension;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import static org.mule.runtime.api.connection.ConnectionValidationResult.success;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class DotaConnectionProvider implements ConnectionProvider<DotaParty> {

  @Parameter
  private List<String> members;

  @Parameter
  private int port;

  @Override
  public DotaParty connect() throws ConnectionException {
    try (Socket socket = new Socket("localhost", port)) {

      InputStream input = socket.getInputStream();
      BufferedReader reader = new BufferedReader(new InputStreamReader(input));

      String time = reader.readLine();

      SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", new Locale("us"));
      return new DotaParty(members, sdf.parse(time));
    } catch (IOException | ParseException ex) {
      throw new ConnectionException(ex);
    }
  }

  @Override
  public void disconnect(DotaParty dotaParty) {
    dotaParty.rageQuit();
  }

  @Override
  public ConnectionValidationResult validate(DotaParty dotaParty) {
    return dotaParty.readyCheck() ? success() : failure(ChebasNotReadyException.MESSAGE, new ChebasNotReadyException());
  }
}
