/**
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.munit.test.extension;

import static java.util.Arrays.asList;
import static org.mule.runtime.extension.api.annotation.param.MediaType.TEXT_PLAIN;

import java.util.List;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@MediaType(value = TEXT_PLAIN, strict = false)
@Alias("listener")
public class DotaMatchFoundListener extends PollingSource<Boolean, MatchFoundAttributes> {


  private static final List<Integer> PLAYER_IDS = asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
  private DotaParty dotaParty;

  @Connection
  private ConnectionProvider<DotaParty> connectionProvider;

  @Override
  protected void doStart() throws MuleException {
    dotaParty = connectionProvider.connect();
  }

  @Override
  protected void doStop() {
    connectionProvider.disconnect(dotaParty);
  }

  @Override
  public void poll(PollContext<Boolean, MatchFoundAttributes> pollContext) {
    if (pollContext.isSourceStopping()) {
      return;
    }
    pollContext.accept(item -> {
      Result<Boolean, MatchFoundAttributes> result =
          Result.<Boolean, MatchFoundAttributes>builder(Message.of(Boolean.TRUE))
              .attributes(new MatchFoundAttributes(dotaParty.getTime(), PLAYER_IDS)).build();
      item.setResult(result);
    });
  }

  @Override
  public void onRejectedItem(Result<Boolean, MatchFoundAttributes> result, SourceCallbackContext sourceCallbackContext) {

  }
}
