/**
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.munit.test.extension;

import org.mule.runtime.extension.api.annotation.param.Connection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DotaOperations {

  private static final List<String> HEROES = Arrays.asList("INVOKER", "PUDGE", "RHASTA", "DAVION", "KUNKKA");

  public Map<String, String> pickHeroes(@Connection DotaParty party) {
    Map<String, String> pickedHeroes = new HashMap<>();
    Iterator<String> iterator = HEROES.iterator();
    party.getMembers().forEach(m -> pickedHeroes.put(m, iterator.next()));
    return pickedHeroes;
  }

  public void farm() {
    throw new RuntimeException("Diegod stop hitting creeps");
  }
}
