/**
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.munit.test.extension;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DotaParty {

  private final List<String> members;
  private final Date time;

  public DotaParty(List<String> members, Date time) {
    this.members = new ArrayList<>(members);
    this.time = time;
  }

  public void rageQuit() {
    members.clear();
  }

  public boolean readyCheck() {
    return !members.contains("chebas");
  }

  public List<String> getMembers() {
    return members;
  }

  public Date getTime() {
    return time;
  }
}
