/*
 * Decompiled with CFR 0.152.
 */
package org.mule.properties;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitUserPropertiesManager {
    private static Set<String> notAllowedPropertyKeys = MUnitUserPropertiesManager.defineNotAllowedPropertyKeys();
    private Properties initialSystemProperties;

    public MUnitUserPropertiesManager() {
        this.storeInitialSystemProperties();
    }

    private static Set<String> defineNotAllowedPropertyKeys() {
        HashSet<String> propertyKeysSet = new HashSet<String>();
        propertyKeysSet.add("java.library.path");
        propertyKeysSet.add("file.encoding");
        propertyKeysSet.add("jdk.map.althashing.threshold");
        return propertyKeysSet;
    }

    public static Boolean isPropertyKeyAllowed(String key) {
        return !notAllowedPropertyKeys.contains(key);
    }

    public void storeInitialSystemProperties() {
        this.initialSystemProperties = (Properties)System.getProperties().clone();
    }

    public void addUserPropertiesToSystem(Map<String, String> userProperties) {
        if (userProperties != null) {
            for (Map.Entry<String, String> entry : userProperties.entrySet()) {
                if (!MUnitUserPropertiesManager.isPropertyKeyAllowed(entry.getKey()).booleanValue()) continue;
                System.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public void restoreInitialSystemProperties() {
        System.setProperties(this.initialSystemProperties);
    }
}

