/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.coverage.printer;

import org.apache.maven.plugin.logging.Log;
import org.mule.coverage.report.MavenCoverageReport;
import org.mule.coverage.report.MuleFlow;
import org.mule.coverage.report.MuleResource;

public class ConsolePrinter implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "Console";

    private Log log;

    public ConsolePrinter(Log log) {
        this.log = log;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(MavenCoverageReport report) {
        log.info("===============================================================================");
        log.info("\t\t\t\tMUnit Coverage Report");
        log.info("===============================================================================");
        log.info("");
        for (MuleResource mr : report.getResources()) {
            log.info("-------------------------------------------------------------------------------");
            if(mr.getCoverage() != -1) {
                log.info("Resource File: " + mr.getName() + " - Flows: " + mr.getFlows().size() + " -  Coverage: " + mr.getCoverage() + "%");
            } else {
                log.info("Resource File: " + mr.getName() + " - Flows: " + mr.getFlows().size() + " -  Coverage: N/A");
            }
            log.info("-------------------------------------------------------------------------------");
            for (MuleFlow mf : mr.getFlows()) {
                log.info("  * Flow:" + mf.getName() + " - Coverage: " + mf.getCoverage() + "%");
            }
        }
        log.info("");
        log.info("===============================================================================");
        log.info("\t\t\t\t\tSummary");
        log.info("===============================================================================");
        log.info("  * MPs: " + report.getApplicationMessageProcessorCount());
        log.info("  * Flows: " + report.getApplicationFlowCount());
        log.info("  * Resources: " + report.getResources().size());
        log.info("===============================================================================");
        if(report.getApplicationFlowCount() > 0){
            log.info("\t\t\t\t** Application Coverage: " + String.format("%.2f",report.getCoverage()) + "% **");
        } else {
            log.info("\t\t\t\t** Application Coverage: N/A **");
        }
        log.info("===============================================================================");

    }
}
