/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.coverage.report;

import java.util.ArrayList;
import java.util.List;

public class MavenCoverageReport {
    private Double coverage;
    private Double branchCoverage;
    private List<MuleResource> resources = new ArrayList<MuleResource>();

    public Double getCoverage() {
        return coverage;
    }

    public void setCoverage(Double coverage) {
        this.coverage = coverage;
    }

    public Double getBranchCoverage() {
        return branchCoverage;
    }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public List<MuleResource> getResources() {
        return resources;
    }

    public void setResources(List<MuleResource> resources) {
        this.resources = resources;
    }

    public Integer getApplicationFlowCount() {
        Integer applicationFlowCount = 0;

        for (MuleResource mr : resources) {
            applicationFlowCount += mr.getFlows().size();
        }
        return applicationFlowCount;
    }

    public Integer getApplicationMessageProcessorCount() {
        Integer applicationMpCount = 0;

        for (MuleResource mr : resources) {
            for (MuleFlow mf : mr.getFlows()) {
                applicationMpCount += mf.getPaths().size();
            }
        }
        return applicationMpCount;
    }
}
