/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.util;

import java.io.InputStream;
import java.util.Properties;

/**
 * This class knows how to access several properties file that belongs (by default) to a Mule application.
 * It also provide specific methods to retrieve particular propreties.
 */
public class MulePropertiesLoader {
    private static final String MULE_DEPLOY_PROPERTIES = "mule-deploy.properties";

    /**
     * It'll return the value of the property config.resources in the file mule-deploy.properties
     *
     * @return the config resources or an empty string.
     */
    public String getConfigResources() {
        Properties props = this.loadProperties("/" + MULE_DEPLOY_PROPERTIES);

        if (props != null && props.getProperty("config.resources") != null) {
            return props.getProperty("config.resources");
        } else {
            return "";
        }
    }

    private Properties loadProperties(String propertyFile) {
        try {
            Properties prop = new Properties();
            InputStream in = getClass().getResourceAsStream(propertyFile);
            prop.load(in);
            in.close();
            return prop;
        } catch (Throwable t) {
            return null;
        }
    }
}
