/*
 * Decompiled with CFR 0.152.
 */
package org.mule.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.mule.properties.MUnitUserPropertiesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPropertyLoader {
    private static final String DEFAULT_APP_FOLDER = "/src/main/app/";
    private static final String DEFAULT_APP_PROPERTIES_RESOURCE = "mule-app.properties";
    private Log log;
    private MUnitUserPropertiesManager propertiesManager;

    public ApplicationPropertyLoader(MUnitUserPropertiesManager propertiesManager, Log log) {
        this.log = log;
        this.propertiesManager = propertiesManager;
    }

    public void loadAndSetApplicationProperties(File projectBasedDir) {
        String appFolderPath = projectBasedDir + DEFAULT_APP_FOLDER;
        File appPropsFile = new File(appFolderPath, DEFAULT_APP_PROPERTIES_RESOURCE);
        try {
            Map<String, String> appPropsMap = this.loadApplicationProperties(appPropsFile);
            this.setApplicationProperties(appPropsMap);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)"mule-app.properties could not be loaded.");
        }
    }

    private Map<String, String> loadApplicationProperties(File appPropsFile) throws IOException {
        HashMap<String, String> appPropsMap = new HashMap<String, String>();
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props = this.loadPropertiesFromFile(appPropsFile.toURI().toURL());
            for (Object key : props.keySet()) {
                appPropsMap.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        return appPropsMap;
    }

    private void setApplicationProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (this.propertiesManager.hasProperty(entry.getKey())) continue;
            this.propertiesManager.addUserPropertyToSystem(entry.getKey(), entry.getValue());
            this.log.debug((CharSequence)("System property [" + entry.getKey() + "] set to: [" + entry.getValue() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(URL url) throws IOException {
        Properties props;
        if (url == null) {
            throw new IOException("Invalid file URL!");
        }
        InputStream is = url.openStream();
        try {
            props = new Properties();
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }
}

