/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;

public class MuleRuntimeDetector {
    /**
     * The purpose of this method is to check if classes inside the jar mule-core-ee can be loaded.
     * If they can it's taken as a token that it's being run over a EE.
     * If such jar is not in the classpath then it's considered it's being run over a CE runtime.
     *
     * @return true is the flag class can be loaded
     */
    public boolean isRunningOnEE() {
        String muleEEFlagClass = "com.mulesoft.mule.config.license.MuleEmbeddedLicenseCheck";
        try {
            MuleRuntimeDetector.class.getClassLoader().loadClass(muleEEFlagClass);
            return true;

        } catch (ClassNotFoundException e) {
            return false;
        }
    }
}
