/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.coverage.report.MavenCoverageReport;
import org.mule.coverage.report.MuleFlow;
import org.mule.coverage.report.MuleResource;
import org.mule.log.MunitMavenLog;
import org.mule.munit.plugins.coverage.CoverageCalculator;
import org.mule.munit.plugins.coverage.PathBuilder;
import org.mule.util.MulePropertiesLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageReportBuilder {
    private MunitMavenLog log;
    private MulePropertiesLoader propertiesLoader;
    private Set<String> flowsToIgnore;

    public CoverageReportBuilder(MunitMavenLog log, MulePropertiesLoader propertiesLoader) {
        this.log = log;
        this.propertiesLoader = propertiesLoader;
    }

    public void setFlowsToIgnore(Set<String> flowsToIgnore) {
        this.flowsToIgnore = flowsToIgnore;
    }

    public MavenCoverageReport buildReport(Set<String> coveredPaths, Set<String> appFlowPaths, Set<String> appSubFlowPaths, Set<String> appBatchPaths) {
        coveredPaths = this.filterIgnoredFlows(coveredPaths);
        appFlowPaths = this.filterIgnoredFlows(appFlowPaths);
        appSubFlowPaths = this.filterIgnoredFlows(appSubFlowPaths);
        appBatchPaths = this.filterIgnoredFlows(appBatchPaths);
        Map<String, List<String>> filesMap = this.buildFilesFlowMap(this.propertiesLoader.getConfigResources());
        Map<String, List<String>> flowsMap = this.buildApplicationFlowPathMap(appFlowPaths, appSubFlowPaths, appBatchPaths);
        CoverageCalculator calculator = new CoverageCalculator(coveredPaths, appFlowPaths, appSubFlowPaths, appBatchPaths);
        CoverageCalculator.CoverageResult coverageResult = calculator.calculate();
        Map flowsCoveredPaths = PathBuilder.buildFlowPathsMap(coveredPaths);
        MavenCoverageReport report = new MavenCoverageReport();
        report.setCoverage(coverageResult.getCoverage());
        for (String fileName : filesMap.keySet()) {
            MuleResource muleResource = new MuleResource(fileName);
            List<String> flowsFromFile = filesMap.get(fileName);
            for (String flowName : flowsFromFile) {
                if (this.flowsToIgnore.contains(flowName)) continue;
                MuleFlow muleFlow = new MuleFlow(flowName);
                if (flowsMap.containsKey(flowName)) {
                    muleFlow.getPaths().addAll((Collection<String>)flowsMap.get(flowName));
                }
                if (flowsCoveredPaths.containsKey(flowName)) {
                    muleFlow.getCoveredPaths().addAll((Collection)flowsCoveredPaths.get(flowName));
                }
                muleResource.getFlows().add(muleFlow);
            }
            report.getResources().add(muleResource);
        }
        return report;
    }

    private Set<String> filterIgnoredFlows(Set<String> paths) {
        if (null != this.flowsToIgnore) {
            return PathBuilder.filterPaths(paths, this.flowsToIgnore);
        }
        return paths;
    }

    private Map<String, List<String>> buildFilesFlowMap(String resources) {
        HashMap<String, List<String>> filesMap = new HashMap<String, List<String>>();
        this.log.debug("Building Files flow map...");
        if (resources != null && !resources.equals("")) {
            for (String resource : resources.split(",")) {
                URL fileUrl = this.getClass().getClassLoader().getResource(resource);
                filesMap.put(resource, this.getFlowsFromFile(fileUrl));
            }
        }
        this.log.debug("Files flow map building done...");
        return filesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFlowsFromFile(URL fileUrl) {
        this.log.debug("Getting flows from file [" + fileUrl + "]");
        ArrayList<String> flowNames = new ArrayList<String>();
        String xpathQuery = "//*[local-name()='flow' or local-name()='sub-flow' or local-name()='job']";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileUrl.openStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nl = (NodeList)xpath.compile(xpathQuery).evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nameAttribute = nl.item(i).getAttributes().getNamedItem("name");
                flowNames.add(nameAttribute.getNodeValue());
            }
        }
        catch (ParserConfigurationException e) {
            this.log.debug("Error parsing file", e);
        }
        catch (SAXException e) {
            this.log.debug("Error parsing file", e);
        }
        catch (FileNotFoundException e) {
            this.log.debug("File not found", e);
        }
        catch (XPathExpressionException e) {
            this.log.debug("Error parsing file", e);
        }
        catch (IOException e) {
            this.log.debug("Error reading file", e);
        }
        finally {
            this.log.debug("Flow names loaded: " + flowNames);
            return flowNames;
        }
    }

    private Map<String, List<String>> buildApplicationFlowPathMap(Set<String> flows, Set<String> subFlows, Set<String> batches) {
        HashMap<String, List<String>> flowsMap = new HashMap<String, List<String>>();
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(flows));
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(subFlows));
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(batches));
        return flowsMap;
    }
}

