/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.maven.plugin.logging.Log;
import org.mule.coverage.server.CoveragePluginReport;
import org.mule.log.MunitMavenLog;

public class MunitCoverageServer
implements Runnable {
    private static final int SOCKET_TIMEOUT_MILLIS = 1800000;
    private MunitMavenLog log;
    private int port;
    private boolean running;
    private CoveragePluginReport report;

    public MunitCoverageServer(int port) {
        this.port = port;
    }

    public synchronized void launch() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        ObjectInputStream in = null;
        ServerSocket providerSocket = null;
        try {
            providerSocket = new ServerSocket(this.port, 10);
            this.log.debug("Coverage server awaiting for coverage connection in port [" + this.port + "]...");
            providerSocket.setSoTimeout(1800000);
            Socket connection = providerSocket.accept();
            this.log.debug("Coverage server connection received from " + connection.getInetAddress().getHostName());
            in = new ObjectInputStream(connection.getInputStream());
            while (true) {
                this.running = true;
                try {
                    String message = (String)in.readObject();
                    Gson gson = new Gson();
                    this.report = (CoveragePluginReport)gson.fromJson(message, CoveragePluginReport.class);
                    this.log.debug("Coverage report received");
                }
                catch (ClassNotFoundException classNot) {
                    this.log.error("Report deserialization fail, no report will be generated");
                }
            }
        }
        catch (SocketTimeoutException timeoutException) {
            this.log.error("Coverage server time out, no report received. No report will be generated");
            try {
                this.log.debug("Shutting down coverage server running in port [" + this.port + "]...");
                this.running = false;
                if (null != in) {
                    in.close();
                }
                if (null != providerSocket) {
                    providerSocket.close();
                }
                this.log.debug("Coverage server shutdown");
            }
            catch (IOException ioException) {
                this.log.debug("Coverage server error during shutdown.");
            }
        }
        catch (IOException ioException) {
            try {
                this.log.debug("Shutting down coverage server running in port [" + this.port + "]...");
                this.running = false;
                if (null != in) {
                    in.close();
                }
                if (null != providerSocket) {
                    providerSocket.close();
                }
                this.log.debug("Coverage server shutdown");
            }
            catch (IOException ioException2) {
                this.log.debug("Coverage server error during shutdown.");
            }
            catch (Throwable throwable) {
                try {
                    this.log.debug("Shutting down coverage server running in port [" + this.port + "]...");
                    this.running = false;
                    if (null != in) {
                        in.close();
                    }
                    if (null != providerSocket) {
                        providerSocket.close();
                    }
                    this.log.debug("Coverage server shutdown");
                }
                catch (IOException ioException3) {
                    this.log.debug("Coverage server error during shutdown.");
                }
                throw throwable;
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public CoveragePluginReport getReport() {
        return this.report;
    }

    public void setLog(Log log) {
        this.log = new MunitMavenLog(log, "CoverageServer");
    }
}

