/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.log;

import org.apache.maven.plugin.logging.Log;

public class MunitMavenLog implements Log {
    private Log log;

    private String logName = "";

    public MunitMavenLog(Log log, String logName) {
        this.log = log;
        this.logName = logName;
    }

    public Log getLog() {
        return log;
    }

    public String getLogName() {
        return logName;
    }

    @Override
    public boolean isDebugEnabled() {
        if (null != log) {
            return log.isDebugEnabled();
        }
        return false;
    }

    @Override
    public void debug(CharSequence content) {
        if (log != null) {
            log.debug("[" + logName + "] " + content);
        }
    }

    @Override
    public void debug(CharSequence content, Throwable error) {
        if (log != null) {
            log.debug("[" + logName + "] " + content, error);
        }
    }

    @Override
    public void debug(Throwable error) {
        if (log != null) {
            log.debug(error);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        if (null != log) {
            return log.isInfoEnabled();
        }
        return false;
    }

    @Override
    public void info(CharSequence content) {
        if (log != null) {
            log.info("[" + logName + "] " + content);
        }
    }

    @Override
    public void info(CharSequence content, Throwable error) {
        if (log != null) {
            log.info("[" + logName + "] " + content, error);
        }
    }

    @Override
    public void info(Throwable error) {
        if (log != null) {
            log.info(error);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        if (null != log) {
            return log.isWarnEnabled();
        }
        return false;
    }

    @Override
    public void warn(CharSequence content) {
        if (log != null) {
            log.warn("[" + logName + "] " + content);
        }
    }

    @Override
    public void warn(CharSequence content, Throwable error) {
        if (log != null) {
            log.warn("[" + logName + "] " + content, error);
        }
    }

    @Override
    public void warn(Throwable error) {
        if (log != null) {
            log.warn(error);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        if (null != log) {
            return log.isErrorEnabled();
        }
        return false;
    }

    @Override
    public void error(CharSequence content) {
        if (log != null) {
            log.error("[" + logName + "] " + content);
        }
    }

    @Override
    public void error(CharSequence content, Throwable error) {
        if (log != null) {
            log.error("[" + logName + "] " + content, error);
        }
    }

    @Override
    public void error(Throwable error) {
        if (log != null) {
            log.error(error);
        }
    }
}
