/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.Coverage;
import org.mule.MuleRuntimeDetector;
import org.mule.coverage.ApplicationPathBuilder;
import org.mule.coverage.CoverageReportBuilder;
import org.mule.coverage.printer.ConsolePrinter;
import org.mule.coverage.printer.HtmlPrinter;
import org.mule.coverage.printer.MavenCoverageReportPrinter;
import org.mule.coverage.printer.SummaryConsolePrinter;
import org.mule.coverage.report.MavenCoverageReport;
import org.mule.coverage.report.MuleFlow;
import org.mule.coverage.report.MuleResource;
import org.mule.coverage.server.MunitCoverageServer;
import org.mule.log.MunitMavenLog;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.runner.properties.MUnitUserPropertiesManager;
import org.mule.util.MulePropertiesLoader;

public class CoverageManager {
    private static final int MIN_PORT_NUMBER = 50000;
    private static final int MAX_PORT_NUMBER = 55000;
    public static final String COVERAGE_NAME_FOLDER = "coverage";
    private MunitMavenLog log;
    private MuleRuntimeDetector muleRuntimeDetector = new MuleRuntimeDetector();
    private Coverage coverageConfiguration;
    private Integer coveragePort;
    private MunitCoverageServer coverageServer;
    private MUnitUserPropertiesManager propertiesManager;
    private Set<String> coveredPaths = new HashSet<String>();
    private List<MavenCoverageReportPrinter> printers = new ArrayList<MavenCoverageReportPrinter>();
    private MavenCoverageReport coverageReport = null;

    public CoverageManager(Coverage coverageConfiguration, MUnitUserPropertiesManager propertiesManager, Log log) {
        this.propertiesManager = propertiesManager;
        this.coverageConfiguration = coverageConfiguration;
        this.log = new MunitMavenLog(log, "CoverageManager");
        this.printers = new ArrayList<MavenCoverageReportPrinter>();
        this.setUpPrinters();
    }

    public void setMuleRuntimeDetector(MuleRuntimeDetector muleRuntimeDetector) {
        this.muleRuntimeDetector = muleRuntimeDetector;
    }

    private boolean isRunningOnEE() {
        return this.muleRuntimeDetector.isRunningOnEE();
    }

    private Boolean shouldRunCoverage() {
        if (!this.isRunningOnEE()) {
            return false;
        }
        if (this.coverageConfiguration == null) {
            return false;
        }
        return this.coverageConfiguration.shouldRunCoverage();
    }

    public void startCoberturaServer() {
        if (!this.shouldRunCoverage().booleanValue()) {
            if (!this.isRunningOnEE()) {
                this.log.info("Coverage feature runs over EE runtime only. Feature is shut down.");
            } else {
                this.log.info("Coverage feature hasn't been enable. Not Gathering coverage data.");
            }
            return;
        }
        this.acquireCoverageServerPort();
        this.coverageServer = new MunitCoverageServer(this.coveragePort);
        this.coverageServer.setLog(this.log.getLog());
        this.log.info("Starting coverage server in port [" + this.coveragePort + "]");
        this.coverageServer.launch();
    }

    public void accountSuiteResults() {
        if (!this.shouldRunCoverage().booleanValue()) {
            return;
        }
        this.log.debug("Accounting suite coverage data...");
        if (this.coverageServer.getReport() != null) {
            this.log.debug("Adding all covered paths");
            this.coveredPaths.addAll(this.coverageServer.getReport().getCoveredPaths());
        } else {
            this.log.debug("Accounting coverage data of suite fail. Not report found.");
        }
    }

    public Boolean failBuild() {
        if (!this.shouldRunCoverage().booleanValue()) {
            return false;
        }
        if (!this.coverageConfiguration.getFailBuild().booleanValue()) {
            return false;
        }
        if (this.coverageConfiguration.getRequiredApplicationCoverage() != -1.0 && this.getReport().getCoverage() < this.coverageConfiguration.getRequiredApplicationCoverage()) {
            return true;
        }
        if (this.coverageConfiguration.getRequiredResourceCoverage() != -1.0) {
            for (MuleResource mr : this.getReport().getResources()) {
                if (mr.getCoverage() == -1.0 || !(mr.getCoverage() < this.coverageConfiguration.getRequiredResourceCoverage())) continue;
                return true;
            }
        }
        if (this.coverageConfiguration.getRequiredFlowCoverage() != -1.0) {
            for (MuleResource mr : this.getReport().getResources()) {
                for (MuleFlow mf : mr.getFlows()) {
                    if (!(mf.getCoverage() < this.coverageConfiguration.getRequiredFlowCoverage())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void printReport() {
        if (!this.shouldRunCoverage().booleanValue()) {
            return;
        }
        MavenCoverageReport report = this.getReport();
        if (this.printers.size() > 0) {
            this.log.info("Printing Coverage Report...");
            this.createCoverageReportFolder();
        } else {
            this.log.info("No printers defined. The Coverage Report won't be printed.");
        }
        for (MavenCoverageReportPrinter printer : this.printers) {
            this.log.debug("Executing: " + printer.getPrinterName() + " printer...");
            printer.printReport(report);
        }
        SummaryConsolePrinter defaultPrinter = new SummaryConsolePrinter(this.log.getLog());
        defaultPrinter.setRequiredApplicationCoverage(this.coverageConfiguration.getRequiredApplicationCoverage());
        defaultPrinter.setRequiredResourceCoverage(this.coverageConfiguration.getRequiredResourceCoverage());
        defaultPrinter.setRequiredFlowCoverage(this.coverageConfiguration.getRequiredFlowCoverage());
        defaultPrinter.setFailBuild(this.coverageConfiguration.getFailBuild());
        defaultPrinter.printReport(report);
    }

    private void setUpPrinters() {
        for (String printFormat : this.coverageConfiguration.getFormats()) {
            if ("Console".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new ConsolePrinter(this.log.getLog()));
                continue;
            }
            if ("HTML".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new HtmlPrinter(this.coverageConfiguration));
                continue;
            }
            this.log.debug("No report format find for: " + printFormat);
        }
    }

    private void acquireCoverageServerPort() {
        FreePortFinder portFinder = new FreePortFinder(50000, 55000);
        if (this.coveragePort == null || !portFinder.isPortFree(this.coveragePort.intValue())) {
            this.coveragePort = portFinder.find();
        }
        this.setCoveragePortProperty();
    }

    private void setCoveragePortProperty() {
        this.propertiesManager.addApplicationPropertyToSystem("cobertura.port", this.coveragePort.toString());
    }

    protected MavenCoverageReport getReport() {
        if (null == this.coverageReport) {
            MulePropertiesLoader propertiesLoader = new MulePropertiesLoader();
            ApplicationPathBuilder appPathBuilder = new ApplicationPathBuilder(propertiesLoader.getConfigResources());
            appPathBuilder.setLog(this.log.getLog());
            CoverageReportBuilder reportBuilder = new CoverageReportBuilder(this.log, propertiesLoader);
            HashSet<String> flowsToIgnore = new HashSet<String>(this.coverageConfiguration.getIgnoreFlows());
            reportBuilder.setFlowsToIgnore(flowsToIgnore);
            this.coverageReport = reportBuilder.buildReport(this.coveredPaths, appPathBuilder.getFlowPaths(), appPathBuilder.getSubFlowPaths(), appPathBuilder.getBatchPaths());
        }
        return this.coverageReport;
    }

    private void createCoverageReportFolder() {
        this.log.debug("Creating coverage folder...");
        new File("./target/munit-reports/coverage").mkdirs();
    }
}

