/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage.report;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleFlow {
    private String name;
    private Double coverage;
    private Double branchCoverage;
    private List<String> paths = new ArrayList<String>();
    private List<String> coveredPaths = new ArrayList<String>();

    public MuleFlow(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Double getCoverage() {
        if (null == this.coverage) {
            this.calculateResourceCoverage();
        }
        return this.coverage;
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getCoveredPaths() {
        return this.coveredPaths;
    }

    public void setCoveredPaths(List<String> coveredPaths) {
        this.coveredPaths = coveredPaths;
    }

    private void calculateResourceCoverage() {
        int pathCount = this.paths.size();
        int coveredPathCount = this.coveredPaths.size();
        this.coverage = pathCount == 0 ? Double.valueOf(-1.0) : Double.valueOf(coveredPathCount * 100 / pathCount);
    }
}

