/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.coverage;

import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugins.coverage.CoberturaPlugin;
import org.mule.munit.runner.simple.MunitSimpleRunner;
import org.mule.munit.runner.simple.MunitSimpleRunnerAction;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * The goal of this class is to build the paths of a Mule application.
 * It require the list of Mule configuration resources to do so.
 */
public class ApplicationPathBuilder {
    private Log log;

    private String resources;
    private String projectName;

    private Boolean executed = false;
    private ApplicationPathCounter pathCounter;

    public ApplicationPathBuilder(String resources, String projectName) {
        this.resources = resources;
        this.projectName = projectName;
    }

    public String getResources() {
        return resources;
    }

    public Set<String> getFlowPaths() {
        if (false == executed) {
            buildApplicationPaths();
        }

        return pathCounter.getFlowPaths();
    }

    public Set<String> getSubFlowPaths() {
        if (false == executed) {
            buildApplicationPaths();
        }
        return pathCounter.getSubFlowPaths();
    }

    public Set<String> getBatchPaths() {
        if (false == executed) {
            buildApplicationPaths();
        }
        return pathCounter.getBatchPaths();
    }

    /**
     * The method starts a Mule context (by MUnit) and once Mule has started it build the paths of all the flows
     * and sub-flows present in the application.
     */
    private void buildApplicationPaths() {
        debug("Counting application flow paths: " + new Date().toString());
        executed = true;
        String originalCoveragePort = System.clearProperty(CoberturaPlugin.COBERTURA_PORT_PROPERTY);

        List<MunitSimpleRunnerAction> actions = new ArrayList<MunitSimpleRunnerAction>();
        pathCounter = new ApplicationPathCounter();
        actions.add(pathCounter);

        MunitSimpleRunner munitSimpleRunner = new MunitSimpleRunner(resources, actions, projectName);
        munitSimpleRunner.run();

        if (null != originalCoveragePort) {
            System.setProperty(CoberturaPlugin.COBERTURA_PORT_PROPERTY, originalCoveragePort);
        }

    }

    public void setLog(Log log) {
        this.log = log;
    }

    private void debug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private void error(String msg) {
        if (log != null) {
            log.error(msg);
        }
    }

}
