/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.coverage.printer;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.FileUtils;
import org.mule.Coverage;
import org.mule.MUnitMojo;
import org.mule.coverage.CoverageManager;
import org.mule.coverage.printer.model.MuleResourceModel;
import org.mule.coverage.printer.model.CoverageReportModel;
import org.mule.coverage.printer.model.MuleFlowModel;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class JsonPrinter implements MavenCoverageReportPrinter {

    public static final String PRINTER_NAME = "Json";
    private static final String REPORT_FOLDER_PATH = MUnitMojo.MUNIT_REPORT_FOLDER_PATH + CoverageManager.JSON_COVERAGE_NAME_FOLDER + File.separator;

    private Coverage configuration;

    public JsonPrinter(Coverage configuration){
        this.configuration = configuration;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        try {
            CoverageReportModel coverageReportModel = generateReportModel(report);
            ObjectMapper mapper = new ObjectMapper();
            new File(REPORT_FOLDER_PATH).mkdir();
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(REPORT_FOLDER_PATH + "report.json"), coverageReportModel);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CoverageReportModel generateReportModel(ApplicationCoverageReport report){
        CoverageReportModel coverageReportModel = new CoverageReportModel(report, configuration);
        List<MuleResourceModel> files = new ArrayList<MuleResourceModel>();
        for(MuleResource resource : report.getResources()){
            MuleResourceModel resourceModel = new MuleResourceModel(resource);
            List<MuleFlowModel> flows = new ArrayList<MuleFlowModel>();
            for(MuleFlow flow : resource.getFlows()){
                flows.add(new MuleFlowModel(flow));
            }
            resourceModel.setFlows(flows);
            files.add(resourceModel);
        }
        coverageReportModel.setFiles(files);
        return coverageReportModel;
    }
}
