package org.mule.coverage.printer.model;

import org.mule.munit.plugins.coverage.report.model.MuleResource;

import java.util.ArrayList;
import java.util.List;

public class MuleResourceModel {

    private double coverage;
    private int flowCount;
    private int messageProcessorCount;
    private List<MuleFlowModel> flows = new ArrayList<MuleFlowModel>();
    private String name;

    public MuleResourceModel(MuleResource resource){
        this.coverage = resource.getCoverage();
        this.name = resource.getName();
        this.flowCount = resource.getFlows().size();
        this.messageProcessorCount = resource.getMessageProcessorCount();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getCoverage() {
        return coverage;
    }

    public List<MuleFlowModel> getFlows() {
        return flows;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void setFlows(List<MuleFlowModel> flows) {
        this.flows = flows;
    }

    public int getFlowCount() {
        return flowCount;
    }

    public int getMessageProcessorCount() {
        return messageProcessorCount;
    }

    public void setFlowCount(int flowCount) {
        this.flowCount = flowCount;
    }

    public void setMessageProcessorCount(int messageProcessorCount) {
        this.messageProcessorCount = messageProcessorCount;
    }
}
