/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.coverage.ApplicationPathCounter;
import org.mule.munit.runner.simple.MunitSimpleRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPathBuilder {
    private Log log;
    private String resources;
    private String projectName;
    private Boolean executed = false;
    private ApplicationPathCounter pathCounter;

    public ApplicationPathBuilder(String resources, String projectName) {
        this.resources = resources;
        this.projectName = projectName;
    }

    public String getResources() {
        return this.resources;
    }

    public Set<String> getFlowPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getFlowPaths();
    }

    public Set<String> getSubFlowPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getSubFlowPaths();
    }

    public Set<String> getBatchPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getBatchPaths();
    }

    private void buildApplicationPaths() {
        this.debug("Counting application flow paths: " + new Date().toString());
        this.executed = true;
        String originalCoveragePort = System.clearProperty("cobertura.port");
        ArrayList<ApplicationPathCounter> actions = new ArrayList<ApplicationPathCounter>();
        this.pathCounter = new ApplicationPathCounter();
        actions.add(this.pathCounter);
        MunitSimpleRunner munitSimpleRunner = new MunitSimpleRunner(this.resources, actions, this.projectName);
        munitSimpleRunner.run();
        if (null != originalCoveragePort) {
            System.setProperty("cobertura.port", originalCoveragePort);
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private void debug(String msg) {
        if (this.log != null) {
            this.log.debug((CharSequence)msg);
        }
    }

    private void error(String msg) {
        if (this.log != null) {
            this.log.error((CharSequence)msg);
        }
    }
}

