/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage.printer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import org.mule.Coverage;
import org.mule.coverage.printer.MavenCoverageReportPrinter;
import org.mule.coverage.printer.model.CoverageReportModel;
import org.mule.coverage.printer.model.MuleFlowModel;
import org.mule.coverage.printer.model.MuleResourceModel;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class JsonPrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "Json";
    private static final String REPORT_FOLDER_PATH = "./target/munit-reports/coverage-json" + File.separator;
    private Coverage configuration;

    public JsonPrinter(Coverage configuration) {
        this.configuration = configuration;
    }

    public String getPrinterName() {
        return PRINTER_NAME;
    }

    public void printReport(ApplicationCoverageReport report) {
        try {
            CoverageReportModel coverageReportModel = this.generateReportModel(report);
            ObjectMapper mapper = new ObjectMapper();
            new File(REPORT_FOLDER_PATH).mkdir();
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(REPORT_FOLDER_PATH + "report.json"), (Object)coverageReportModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CoverageReportModel generateReportModel(ApplicationCoverageReport report) {
        CoverageReportModel coverageReportModel = new CoverageReportModel(report, this.configuration);
        ArrayList<MuleResourceModel> files = new ArrayList<MuleResourceModel>();
        for (MuleResource resource : report.getResources()) {
            MuleResourceModel resourceModel = new MuleResourceModel(resource);
            ArrayList<MuleFlowModel> flows = new ArrayList<MuleFlowModel>();
            for (MuleFlow flow : resource.getFlows()) {
                flows.add(new MuleFlowModel(flow));
            }
            resourceModel.setFlows(flows);
            files.add(resourceModel);
        }
        coverageReportModel.setFiles(files);
        return coverageReportModel;
    }
}

