/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.Coverage;
import org.mule.coverage.CoverageManager;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.result.MunitResult;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.DummyNotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListenerDecorator;
import org.mule.munit.runner.mule.result.notification.StreamNotificationListener;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;
import org.mule.munit.runner.properties.MUnitUserPropertiesManager;
import org.mule.notifiers.xml.XmlNotificationListener;
import org.mule.util.ConsoleLogPrinter;
import org.mule.util.MunitLog4jLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitMojo
extends AbstractMojo {
    private static final String DEFAULT_MUNIT_BASE_SRC_FOLDER = "src/test/munit";
    public static final String TARGET_SUREFIRE_REPORTS_MUNIT_TXT = "/target/surefire-reports/munit.";
    public static final String TARGET_SUREFIRE_REPORTS_TEST_MUNIT_XML = "/target/surefire-reports/TEST-munit.";
    private static final String SKIP_TESTS_PROPERTY = "skipTests";
    private static final String SKIP_MUNIT_TESTS_PROPERTY = "skipMunitTests";
    private static final String SKIP_ZIP_LOADING_PROPERTY = "skipZipLoading";
    private static final int MIN_PORT_NUMBER = 40000;
    private static final int MAX_PORT_NUMBER = 50000;
    public static final String SINGLE_TEST_NAME_TOKEN = "#";
    public static final String MUNIT_REPORT_FOLDER_NAME = "munit-reports";
    public String munitReportBaseFolderPath;
    protected MavenProject project;
    protected String munittest;
    protected String testToRunName;
    protected boolean logToFile;
    protected Map<String, String> systemPropertyVariables;
    protected List<String> dynamicPorts;
    protected List<String> classpathElements;
    protected Coverage coverage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty(SKIP_TESTS_PROPERTY))) {
            if (!"true".equals(System.getProperty(SKIP_MUNIT_TESTS_PROPERTY))) {
                MUnitUserPropertiesManager.storeInitialSystemProperties();
                try {
                    this.doExecute();
                }
                finally {
                    MUnitUserPropertiesManager.restoreInitialSystemProperties();
                }
            } else {
                this.getLog().info((CharSequence)"Run of munit-maven-plugin skipped. Property [skipMunitTests] was set to true");
            }
        } else {
            this.getLog().info((CharSequence)"Run of munit-maven-plugin skipped. Property [skipTests] was set to true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() throws MojoExecutionException {
        if (this.logToFile) {
            this.getLog().debug((CharSequence)"The property log.to.file is deprecated and we'll make no use of it. Please remove it from your configuration as it will be completely removed in future versions.");
        }
        this.setUpProjectPaths();
        this.addSystemPropertyVariables();
        this.setDynamicPortValues();
        this.stopLicenseCheck();
        CoverageManager coverageManager = this.buildCoverageManager();
        List testResources = this.project.getTestResources();
        for (Object o : testResources) {
            Resource testResource = (Resource)o;
            testResource.getTargetPath();
        }
        try {
            ArrayList<SuiteResult> results = new ArrayList<SuiteResult>();
            this.addUrlsToClassPath(this.makeClassPath());
            this.loadZipDependenciesToClassPath();
            File munitSourceFolder = new File(this.project.getBasedir(), DEFAULT_MUNIT_BASE_SRC_FOLDER);
            if (munitSourceFolder == null || !munitSourceFolder.exists()) {
                this.getLog().warn((CharSequence)"The project has no src/test/munit folder. Aborting MUnit test run.");
                return;
            }
            this.getLog().debug((CharSequence)("MUnit root folder found at: " + munitSourceFolder.getAbsolutePath()));
            coverageManager.startCoverageServer();
            Collection<File> allFiles = this.getMunitTestSuiteFileList(munitSourceFolder);
            for (File file : allFiles) {
                String fileName = file.getPath().replace(munitSourceFolder.getPath() + File.separator, "");
                this.parseFilter();
                if (fileName.endsWith(".xml") && this.validateFilter(fileName)) {
                    results.add(this.buildRunnerFor(fileName).run());
                    continue;
                }
                this.getLog().debug((CharSequence)("MUnit Test Suite file " + fileName + " skipped. It doesn't match filter criteria: [" + this.munittest + "]"));
            }
            coverageManager.stopCoverageServer();
            coverageManager.printReport();
            Boolean resultSuccess = this.show(results);
            if (!resultSuccess.booleanValue()) {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoExecutionException("MUnit Tests Failed"));
            }
            if (coverageManager.failBuild().booleanValue()) {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoFailureException("Coverage limits were not reached"));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setUpProjectPaths() {
        this.munitReportBaseFolderPath = this.project.getBuild().getDirectory() + File.separator + MUNIT_REPORT_FOLDER_NAME + File.separator;
    }

    private CoverageManager buildCoverageManager() {
        CoverageManager coverageManager = new CoverageManager(this.coverage, this.getProjectName(), this.munitReportBaseFolderPath, this.getLog());
        this.getLog().debug((CharSequence)("Coverage Manager Build for project: " + this.getProjectName() + " - " + this.project.getBasedir()));
        this.getLog().debug((CharSequence)this.project.getBuild().getDirectory());
        return coverageManager;
    }

    private void stopLicenseCheck() {
        this.getLog().debug((CharSequence)"Avoid license check for Mule EE components...");
        MUnitUserPropertiesManager.addUserPropertyToSystem((String)"mule.testingMode", (String)"true");
    }

    private Collection<File> getMunitTestSuiteFileList(File munitTestFolder) throws FileNotFoundException {
        ArrayList<File> munitTestSuiteFiles = new ArrayList<File>();
        Collection allFiles = FileUtils.listFiles((File)munitTestFolder, null, (boolean)true);
        for (File file : allFiles) {
            if (!this.isValidMunitTestSuiteFile(file)) continue;
            munitTestSuiteFiles.add(file);
        }
        return munitTestSuiteFiles;
    }

    private boolean isValidMunitTestSuiteFile(File file) throws FileNotFoundException {
        String MUNIT_TEST_SUITE_FILE_MARKER = "munit:config";
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains(MUNIT_TEST_SUITE_FILE_MARKER)) continue;
            scanner.close();
            return true;
        }
        scanner.close();
        return false;
    }

    private Boolean show(List<SuiteResult> results) throws MojoExecutionException {
        boolean success = true;
        MunitLog4jLogger.log("===============================================================================");
        MunitLog4jLogger.log("MUnit Run Summary                                                              ");
        MunitLog4jLogger.log("===============================================================================");
        int testCount = 0;
        int errorCount = 0;
        int failCount = 0;
        int skipCount = 0;
        for (SuiteResult run : results) {
            List failingTests = run.getFailingTests();
            List errorTests = run.getErrorTests();
            MunitLog4jLogger.log(" >> " + FilenameUtils.getName((String)run.getTestName()) + " test result: Tests: " + run.getNumberOfTests() + ", Errors: " + errorTests.size() + ", Failures:" + failingTests.size() + ", Skipped: " + run.getNumberOfSkipped());
            this.showFailures(failingTests);
            this.showError(errorTests);
            testCount += run.getNumberOfTests();
            errorCount += errorTests.size();
            failCount += failingTests.size();
            skipCount += run.getNumberOfSkipped();
            if (failingTests.isEmpty() && errorTests.isEmpty()) continue;
            success = false;
        }
        MunitLog4jLogger.log("\t");
        MunitLog4jLogger.log("===============================================================================");
        MunitLog4jLogger.log(" > Tests:   \t" + testCount);
        MunitLog4jLogger.log(" > Errors:  \t" + errorCount);
        MunitLog4jLogger.log(" > Failures:\t" + failCount);
        MunitLog4jLogger.log(" > Skipped: \t" + skipCount);
        MunitLog4jLogger.log("===============================================================================");
        return success;
    }

    private void showFailures(List<MunitResult> failingTests) {
        this.showUnsuccessfulTests(failingTests, "FAILED");
    }

    private void showError(List<MunitResult> errorTests) {
        this.showUnsuccessfulTests(errorTests, "ERROR");
    }

    private void showUnsuccessfulTests(List<MunitResult> unsuccessfulTests, String unsuccessfulTag) {
        if (!unsuccessfulTests.isEmpty()) {
            for (MunitResult result : unsuccessfulTests) {
                MunitLog4jLogger.log("\t --- " + result.getTestName() + " <<< " + unsuccessfulTag);
            }
        }
    }

    private MunitSuiteRunner buildRunnerFor(String fileName) {
        ArrayList<String> testNameList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.testToRunName)) {
            testNameList.add(this.testToRunName);
        }
        this.getLog().debug((CharSequence)("Running MUnit Test Suite: " + fileName + ", for test names: " + testNameList));
        MunitSuiteRunner runner = new MunitSuiteRunner(fileName, testNameList, this.getProjectName());
        NotificationListenerDecorator listener = new NotificationListenerDecorator();
        listener.addNotificationListener((NotificationListener)this.buildLogNotificationListener());
        listener.addNotificationListener(this.buildFileNotificationListener(fileName));
        listener.addNotificationListener(this.buildXmlNotificationListener(fileName));
        runner.setNotificationListener((NotificationListener)listener);
        ArrayList<ConsoleLogPrinter> mojoPrinters = new ArrayList<ConsoleLogPrinter>();
        mojoPrinters.add(new ConsoleLogPrinter());
        runner.setHandler((TestOutputHandler)new DefaultOutputHandler(mojoPrinters));
        return runner;
    }

    private String getProjectName() {
        return this.project.getArtifactId();
    }

    private void addSystemPropertyVariables() {
        this.getLog().info((CharSequence)"Setting system property variables...");
        if (null != this.systemPropertyVariables) {
            for (Map.Entry<String, String> entry : this.systemPropertyVariables.entrySet()) {
                if (MUnitUserPropertiesManager.hasSystemProperty((String)entry.getKey())) continue;
                MUnitUserPropertiesManager.addUserPropertyToSystem((String)entry.getKey(), (String)entry.getValue());
                this.getLog().debug((CharSequence)("System property [" + entry.getKey() + "] set to: [" + entry.getValue() + "]"));
            }
        }
        this.getLog().debug((CharSequence)"System property variables set [DONE]");
    }

    private void setDynamicPortValues() {
        this.getLog().info((CharSequence)"Acquiring dynamic ports...");
        FreePortFinder portFinder = new FreePortFinder(40000, 50000);
        if (null != this.dynamicPorts) {
            for (String portPlaceHolder : this.dynamicPorts) {
                Integer dynamicPort = portFinder.find();
                MUnitUserPropertiesManager.addUserPropertyToSystem((String)portPlaceHolder, (String)dynamicPort.toString());
                this.getLog().debug((CharSequence)("Dynamic port [" + portPlaceHolder + "] set to: [" + dynamicPort.toString() + "]"));
            }
        }
        this.getLog().debug((CharSequence)"Dynamic port definition [DONE]");
    }

    private NotificationListener buildFileNotificationListener(String fileName) {
        fileName = fileName.replace(".xml", ".txt");
        fileName = fileName.replace('/', '.');
        try {
            return new StreamNotificationListener(new PrintStream(new FileOutputStream(this.getFile(this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_MUNIT_TXT + fileName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
    }

    private NotificationListener buildXmlNotificationListener(String fileName) {
        fileName = fileName.replace('/', '.');
        try {
            return new XmlNotificationListener(fileName, new PrintStream(new FileOutputStream(this.getFile(this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_TEST_MUNIT_XML + fileName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
    }

    private StreamNotificationListener buildLogNotificationListener() {
        return new StreamNotificationListener(new PrintStream(System.out){

            public void print(String s) {
                MunitLog4jLogger.log(s);
            }

            public void println(String s) {
                MunitLog4jLogger.log(s);
            }
        });
    }

    private void parseFilter() {
        if (StringUtils.isNotBlank((String)this.munittest) && this.munittest.contains(SINGLE_TEST_NAME_TOKEN)) {
            this.testToRunName = this.munittest.substring(this.munittest.indexOf(SINGLE_TEST_NAME_TOKEN) + 1);
            this.munittest = this.munittest.substring(0, this.munittest.indexOf(SINGLE_TEST_NAME_TOKEN));
        } else {
            this.testToRunName = "";
        }
    }

    private boolean validateFilter(String fileName) {
        if (this.munittest == null) {
            return true;
        }
        return fileName.matches(this.munittest);
    }

    public URLClassLoader getClassPath(List<URL> classpath) {
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> makeClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classpathElements.size());
        for (String e : this.classpathElements) {
            urls.add(new File(e).toURL());
        }
        return urls;
    }

    private void addUrlsToClassPath(List<URL> urls) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    private void loadZipDependenciesToClassPath() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, MalformedURLException {
        if ("true".equals(System.getProperty(SKIP_ZIP_LOADING_PROPERTY))) {
            this.getLog().debug((CharSequence)"Skipping loading of zip dependencies. Property [skipZipLoading] was set to true");
            return;
        }
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        Set artifacts = this.project.getArtifacts();
        for (Artifact a : artifacts) {
            if (!a.getFile().getPath().endsWith(".zip")) continue;
            this.getLog().debug((CharSequence)("Loading artifact[" + a.getFile().getPath() + "]"));
            URL url = a.getFile().toURI().toURL();
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    private File getFile(String fullPath) throws IOException {
        File file = new File(fullPath);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdir()) {
            throw new IOException("Failed to create directory " + file.getParent());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Failed to create file " + file.getName());
        }
        return file;
    }
}

