/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage.printer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.NumberTool;
import org.mule.Coverage;
import org.mule.coverage.printer.MavenCoverageReportPrinter;
import org.mule.coverage.printer.ReportFileWriter;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class HtmlPrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "HTML";
    private static final String ASSETS_FOLDER = "assets/";
    private static final String STYLES_FOLDER = "styles/";
    private static final String SCRIPTS_FOLDER = "js/";
    private static final String ICONS_FOLDER = "icons/";
    private static final String FONTS_FOLDER = "fonts/";
    private static final String SUMMARY_TEMPLATE_FILE_NAME = "summary-template.html";
    private static final String RESOURCE_TEMPLATE_FILE_NAME = "resource-template.html";
    private static final String MULESOFT_STYLES = "mulesoft-styles.css";
    private static final String TSORTER_STYLES = "tsorter.css";
    private static final String MULESOFT_ICON = "icons/004_logo.svg";
    private static final String MULESOFT_ICON_TTF = "fonts/muleicons.ttf";
    private static final String TSORTER_SCRIPT = "tsorter.min.js";
    private Coverage configuration;
    private final String reportFolderPath;
    private ReportFileWriter reportFileWriter = new ReportFileWriter();

    public HtmlPrinter(Coverage configuration, String reportFolderBasePath) {
        this.configuration = configuration;
        this.reportFolderPath = reportFolderBasePath + "coverage" + File.separator;
    }

    public String getPrinterName() {
        return PRINTER_NAME;
    }

    public void printReport(ApplicationCoverageReport report) {
        try {
            this.printSummary(report);
            this.printResources(report);
            this.addAssets();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReportFileWriter(ReportFileWriter reportFileWriter) {
        this.reportFileWriter = reportFileWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSummary(ApplicationCoverageReport report) throws IOException {
        Velocity.init();
        Reader reader = null;
        InputStream inputStream = null;
        StringWriter writer = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(SUMMARY_TEMPLATE_FILE_NAME);
            reader = new InputStreamReader(inputStream, "UTF-8");
            VelocityContext context = new VelocityContext();
            context.put("applicationFlowCount", (Object)report.getApplicationFlowCount());
            context.put("applicationCoverage", (Object)String.format("%.2f", report.getCoverage()));
            context.put("applicationResourceLines", (Object)report.getResources());
            context.put("configuration", (Object)this.configuration);
            context.put("numberTool", (Object)new NumberTool());
            writer = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)writer, (String)"Rendering Coverage Summary Report", (Reader)reader);
            this.reportFileWriter.writeToFile(this.reportFolderPath + "summary.html", writer.getBuffer().toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            if (null != reader) {
                reader.close();
            }
            if (null != inputStream) {
                inputStream.close();
            }
            if (null != writer) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResources(ApplicationCoverageReport report) throws IOException {
        Velocity.init();
        Reader reader = null;
        StringWriter writer = null;
        InputStream inputStream = null;
        for (MuleResource mr : report.getResources()) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_TEMPLATE_FILE_NAME);
                reader = new InputStreamReader(inputStream, "UTF-8");
                VelocityContext context = new VelocityContext();
                context.put("resourceName", (Object)mr.getName());
                context.put("resourceMpCovered", (Object)mr.getCoveredMessageProcessorCount());
                context.put("resourceMpCount", (Object)mr.getMessageProcessorCount());
                context.put("resourceCoverage", (Object)String.format("%.2f", mr.getCoverage()));
                context.put("flowLines", (Object)mr.getFlows());
                context.put("configuration", (Object)this.configuration);
                writer = new StringWriter();
                Velocity.evaluate((Context)context, (Writer)writer, (String)"Rendering Flow Report", (Reader)reader);
                this.reportFileWriter.writeToFile(this.reportFolderPath + this.reportFileWriter.getHtmlFileName(mr.getName()), writer.getBuffer().toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            finally {
                if (null != reader) {
                    reader.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null == writer) continue;
                writer.close();
            }
        }
    }

    private void addAssets() {
        this.addStyles();
        this.addScripts();
    }

    private void addStyles() {
        try {
            String stylesPath = this.reportFolderPath + ASSETS_FOLDER + STYLES_FOLDER;
            this.reportFileWriter.copyFile(MULESOFT_STYLES, stylesPath + MULESOFT_STYLES);
            this.reportFileWriter.copyFile(MULESOFT_ICON, stylesPath + MULESOFT_ICON);
            this.reportFileWriter.copyFile(MULESOFT_ICON_TTF, stylesPath + MULESOFT_ICON_TTF);
            this.reportFileWriter.copyFile(TSORTER_STYLES, stylesPath + TSORTER_STYLES);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addScripts() {
        try {
            String scriptsPath = this.reportFolderPath + ASSETS_FOLDER + SCRIPTS_FOLDER;
            this.reportFileWriter.copyFile(TSORTER_SCRIPT, scriptsPath + TSORTER_SCRIPT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

