package org.mule.coverage.printer.model;


import org.mule.Coverage;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;

import java.util.ArrayList;
import java.util.List;

public class CoverageReportModel {

    private double coverage;
    private double requiredApplicationCoverage;
    private double requiredResourceCoverage;
    private double requiredFlowCoverage;
    private int flowCount;
    private int messageProcessorCount;
    private int coveredMessageProcessorCount;
    private List<MuleResourceModel> files = new ArrayList<MuleResourceModel>();

    public CoverageReportModel(ApplicationCoverageReport report, Coverage configuration){
        this.coverage = report.getCoverage();
        this.flowCount = report.getApplicationFlowCount();
        this.messageProcessorCount = report.getApplicationMessageProcessorCount();
        this.coveredMessageProcessorCount= report.getApplicationCoveredMessageProcessorCount();
        this.requiredApplicationCoverage = configuration.getRequiredApplicationCoverage();
        this.requiredResourceCoverage = configuration.getRequiredResourceCoverage();
        this.requiredFlowCoverage = configuration.getRequiredFlowCoverage();
    }

    public double getCoverage() {
        return coverage;
    }

    public List<MuleResourceModel> getFiles() {
        return files;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void setFiles(List<MuleResourceModel> files) {
        this.files = files;
    }

    public double getRequiredApplicationCoverage() {
        return requiredApplicationCoverage;
    }

    public double getRequiredFlowCoverage() {
        return requiredFlowCoverage;
    }

    public double getRequiredResourceCoverage() {
        return requiredResourceCoverage;
    }

    public void setRequiredApplicationCoverage(double requiredApplicationCoverage) {
        this.requiredApplicationCoverage = requiredApplicationCoverage;
    }

    public void setRequiredFlowCoverage(double requiredFlowCoverage) {
        this.requiredFlowCoverage = requiredFlowCoverage;
    }

    public void setRequiredResourceCoverage(double requiredResourceCoverage) {
        this.requiredResourceCoverage = requiredResourceCoverage;
    }

    public int getFlowCount() {
        return flowCount;
    }

    public int getMessageProcessorCount() {
        return messageProcessorCount;
    }

    public void setFlowCount(int flowCount) {
        this.flowCount = flowCount;
    }

    public void setMessageProcessorCount(int messageProcessorCount) {
        this.messageProcessorCount = messageProcessorCount;
    }

    public int getCoveredMessageProcessorCount() {
        return coveredMessageProcessorCount;
    }

    public void setCoveredMessageProcessorCount(int coveredMessageProcessorCount) {
        this.coveredMessageProcessorCount = coveredMessageProcessorCount;
    }
}
