/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;

public class MulePropertiesLoader {
    private static final String MULE_DEPLOY_PROPERTIES = "mule-deploy.properties";
    private static final String MULE_DEPLOY_PROPERTIES_RELATIVE_PATH = File.separator + "target" + File.separator + "classes" + File.separator + "mule-deploy.properties";
    private static final String MULE_DEPLOY_PROPERTIES_TEST_RELATIVE_PATH = File.separator + "target" + File.separator + "test-classes" + File.separator + "mule-deploy.properties";
    private transient Log log;
    private String projectName;

    public MulePropertiesLoader(String projectName, Log log) {
        this.log = log;
        this.projectName = projectName;
    }

    public String getConfigResources() {
        Properties props = this.loadProperties();
        if (props != null && props.getProperty("config.resources") != null) {
            return props.getProperty("config.resources");
        }
        return "";
    }

    private Properties loadProperties() {
        try {
            Properties prop = new Properties();
            URL muleDeployPropertiesUrl = this.findMuleDeployProperties();
            if (null == muleDeployPropertiesUrl) {
                return null;
            }
            InputStream in = muleDeployPropertiesUrl.openStream();
            prop.load(in);
            in.close();
            return prop;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private URL findMuleDeployProperties() throws IOException {
        URL muleDeployPropertiesUrl = null;
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(MULE_DEPLOY_PROPERTIES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!this.doesTheFileBelongToTheApplication(url)) continue;
            this.log.debug((CharSequence)("Found mule-deploy.properties file at: " + url.getPath()));
            muleDeployPropertiesUrl = url;
            break;
        }
        if (null == muleDeployPropertiesUrl) {
            this.log.debug((CharSequence)"Failed to find mule-deploy.properties file");
        }
        return muleDeployPropertiesUrl;
    }

    private boolean doesTheFileBelongToTheApplication(URL url) {
        String path = new File(url.getPath()).getPath();
        return path.contains(this.projectName + MULE_DEPLOY_PROPERTIES_RELATIVE_PATH) || path.contains(this.projectName + MULE_DEPLOY_PROPERTIES_TEST_RELATIVE_PATH);
    }
}

